/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jsonschema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.internal.CollectionUtils;

public enum TypeCategory {
    BEAN,
    MAP,
    COLLECTION,
    ARRAY,
    BOOLEAN,
    NUMBER,
    STRING,
    ENUM,
    OTHER,
    ANY;


    public static Set<TypeCategory> parse(String s) {
        if (s == null || s.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<TypeCategory> set = CollectionUtils.set(new TypeCategory[0]);
        StringUtils.split(s, x -> set.add(TypeCategory.valueOf(x.toUpperCase())));
        return set;
    }

    public static TypeCategory[] parseArray(String s) {
        if (s == null || s.isEmpty()) {
            return new TypeCategory[0];
        }
        ArrayList<TypeCategory> list = CollectionUtils.list(new TypeCategory[0]);
        StringUtils.split(s, x -> list.add(TypeCategory.valueOf(x.toUpperCase())));
        return list.toArray(new TypeCategory[list.size()]);
    }
}

