/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.arg;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.juneau.AnnotationWorkList;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Value;
import org.apache.juneau.collections.JsonList;
import org.apache.juneau.collections.JsonMap;
import org.apache.juneau.common.internal.StringUtils;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.annotation.HeaderAnnotation;
import org.apache.juneau.httppart.HttpPartCollectionFormat;
import org.apache.juneau.httppart.HttpPartParser;
import org.apache.juneau.httppart.HttpPartParserSession;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.CollectionUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ParamInfo;
import org.apache.juneau.rest.RestOpSession;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.arg.ArgException;
import org.apache.juneau.rest.arg.RestOpArg;
import org.apache.juneau.rest.httppart.RequestHeaders;

public class HeaderArg
implements RestOpArg {
    private final HttpPartParser partParser;
    private final HttpPartSchema schema;
    private final boolean multi;
    private final String name;
    private final String def;
    private final ClassInfo type;

    public static HeaderArg create(ParamInfo paramInfo, AnnotationWorkList annotations) {
        if (!paramInfo.getParameterType().is(Value.class) && (paramInfo.hasAnnotation(Header.class) || paramInfo.getParameterType().hasAnnotation(Header.class))) {
            return new HeaderArg(paramInfo, annotations);
        }
        return null;
    }

    protected HeaderArg(ParamInfo pi, AnnotationWorkList annotations) {
        this.name = (String)HeaderAnnotation.findName((ParamInfo)pi).orElseThrow(() -> new ArgException(pi, "@Header used without name or value", new Object[0]));
        this.def = (String)HeaderAnnotation.findDef((ParamInfo)pi).orElse(null);
        this.type = pi.getParameterType();
        this.schema = HttpPartSchema.create(Header.class, (ParamInfo)pi);
        Class pp = this.schema.getParser();
        this.partParser = pp != null ? (HttpPartParser)HttpPartParser.creator().type(pp).apply(annotations).create() : null;
        boolean bl = this.multi = this.schema.getCollectionFormat() == HttpPartCollectionFormat.MULTI;
        if (this.multi && !this.type.isCollectionOrArray()) {
            throw new ArgException(pi, "Use of multipart flag on @Header parameter that is not an array or Collection", new Object[0]);
        }
    }

    @Override
    public Object resolve(RestOpSession opSession) throws Exception {
        RestRequest req = opSession.getRequest();
        HttpPartParserSession ps = this.partParser == null ? req.getPartParserSession() : this.partParser.getPartSession();
        RequestHeaders rh = req.getHeaders();
        BeanSession bs = req.getBeanSession();
        ClassMeta cm = bs.getClassMeta(this.type.innerType(), new Type[0]);
        if (this.multi) {
            ArrayList c = cm.isArray() ? CollectionUtils.list((Object[])new Object[0]) : (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new JsonList());
            rh.stream(this.name).map(x -> x.parser(ps).schema(this.schema).as(cm.getElementType()).orElse(null)).forEach(x -> c.add(x));
            return cm.isArray() ? ArrayUtils.toArray((Collection)c, (Class)cm.getElementType().getInnerClass()) : c;
        }
        if (cm.isMapOrBean() && StringUtils.isOneOf((String)this.name, (String[])new String[]{"*", ""})) {
            JsonMap m = new JsonMap();
            rh.forEach(x -> m.put(x.getName(), x.parser(ps).schema(this.schema == null ? null : this.schema.getProperty(x.getName())).as(cm.getValueType()).orElse(null)));
            return req.getBeanSession().convertToType((Object)m, cm);
        }
        return rh.getLast(this.name).parser(ps).schema(this.schema).def(this.def).as(this.type.innerType(), new Type[0]).orElse(null);
    }
}

