/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.htmltowiki.syntax;

import java.io.PrintWriter;
import org.apache.wiki.htmltowiki.XHtmlElementToWikiTranslator;
import org.apache.wiki.htmltowiki.syntax.MarkupHelper;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.JDOMException;

public abstract class InputDecorator {
    protected final PrintWriter out;
    protected final XHtmlElementToWikiTranslator chain;

    protected InputDecorator(PrintWriter out, XHtmlElementToWikiTranslator chain) {
        this.out = out;
        this.chain = chain;
    }

    public void decorate(Element e) throws JDOMException {
        String type = e.getAttributeValue("type");
        String name = MarkupHelper.nameSansNbf(e);
        String value = e.getAttributeValue("value");
        String checked = e.getAttributeValue("checked");
        this.out.print(this.markupInputOpen());
        this.printInputAttribute("type", type);
        this.printInputAttribute("name", name);
        this.printInputAttribute("value", value);
        this.printInputAttribute("checked", checked);
        this.out.print(this.markupInputClose());
        this.chain.translate((Content)e);
    }

    void printInputAttribute(String attr, String value) {
        if (value != null) {
            this.out.print(this.markupForInputAttribute(attr, value));
        }
    }

    protected abstract String markupForInputAttribute(String var1, String var2);

    protected abstract String markupInputOpen();

    protected abstract String markupInputClose();
}

