/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.component;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Array;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jetty.util.Jetty;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.Invocable;

@ManagedObject(value="Dumpable Object")
public interface Dumpable {
    public static final String LEGEND = "legend: +- bean, += managed, +~ unmanaged, +? auto, +: iterable, +] array, +} map, +> pojo; @ visited\n";

    @ManagedOperation(value="Dump the nested Object state as a String", impact="INFO")
    default public String dump() {
        return Dumpable.dump(this);
    }

    public void dump(Appendable var1, String var2) throws IOException;

    public static String dump(Dumpable dumpable) {
        DumpAppendable buffer = new DumpAppendable();
        Dumpable.dump(dumpable, buffer);
        return buffer.toString();
    }

    public static void dump(Dumpable dumpable, Appendable out) {
        out = DumpAppendable.ensure(out);
        try {
            dumpable.dump(out, "");
            out.append(LEGEND);
            Runtime runtime = Runtime.getRuntime();
            Instant now2 = Instant.now();
            out.append("JVM: %s %s %s; OS: %s %s %s; Jetty: %s; CPUs: %d; mem(free/total/max): %,d/%,d/%,d MiB\nUTC: %s; %s: %s".formatted(System.getProperty("java.vm.vendor"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), Jetty.VERSION, runtime.availableProcessors(), runtime.freeMemory() / 0x100000L, runtime.totalMemory() / 0x100000L, runtime.maxMemory() / 0x100000L, DateTimeFormatter.ISO_DATE_TIME.format(now2.atOffset(ZoneOffset.UTC)), ZoneId.systemDefault(), DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(now2.atZone(ZoneId.systemDefault()))));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    default public String dumpSelf() {
        return this.toString();
    }

    public static void dumpObject(Appendable out, Object o) throws IOException {
        out = DumpAppendable.ensure(out);
        try {
            String s;
            if (o == null) {
                s = "null";
            } else if (o instanceof Dumpable) {
                s = ((Dumpable)o).dumpSelf();
                s = StringUtil.replace(s, "\r\n", "|");
                s = StringUtil.replace(s, '\n', '|');
            } else if (o instanceof Collection) {
                Collection collection = (Collection)o;
                s = String.format("%s@%x(size=%d)", TypeUtil.toShortName(o.getClass()), o.hashCode(), collection.size());
            } else if (o.getClass().isArray()) {
                s = String.format("%s@%x[size=%d]", o.getClass().getComponentType(), o.hashCode(), Array.getLength(o));
            } else if (o instanceof Map) {
                Map map = (Map)o;
                s = String.format("%s@%x{size=%d}", TypeUtil.toShortName(o.getClass()), o.hashCode(), map.size());
            } else if (o instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)o;
                s = String.format("%s=%s", entry.getKey(), entry.getValue());
            } else {
                s = String.valueOf(o);
                s = StringUtil.replace(s, "\r\n", "|");
                s = StringUtil.replace(s, '\n', '|');
            }
            out.append(s);
            if (o instanceof Invocable) {
                Invocable invocable = (Invocable)o;
                out.append(" ~ ").append(invocable.getInvocationType().toString());
            }
            if (o instanceof LifeCycle) {
                LifeCycle lifecycle = (LifeCycle)o;
                out.append(" - ").append(AbstractLifeCycle.getState(lifecycle));
            }
            out.append("\n");
        }
        catch (Throwable th) {
            out.append("=> ").append(th.toString()).append("\n");
        }
    }

    public static void dumpObjects(Appendable out, String indent, Object object, Object ... extraChildren) throws IOException {
        int extras;
        out = DumpAppendable.ensure(out);
        Dumpable.dumpObject(out, object);
        if (DumpAppendable.hasVisited(out, object)) {
            return;
        }
        DumpAppendable.visit(out, object);
        int n = extras = extraChildren == null ? 0 : extraChildren.length;
        if (object instanceof Stream) {
            object = ((Stream)object).toArray();
        }
        if (object instanceof Array) {
            object = Arrays.asList(object);
        }
        if (object instanceof Container) {
            Dumpable.dumpContainer(out, indent, (Container)object, extras == 0);
        } else if (object instanceof Iterable && !(object instanceof Path)) {
            Dumpable.dumpIterable(out, indent, (Iterable)object, extras == 0);
        } else if (object instanceof Map) {
            Dumpable.dumpMapEntries(out, indent, (Map)object, extras == 0);
        }
        if (extras == 0) {
            return;
        }
        int i = 0;
        for (Object item : extraChildren) {
            String nextIndent = indent + (++i < extras ? "|  " : "   ");
            out.append(indent).append("+>");
            if (DumpAppendable.hasVisited(out, item)) {
                out.append("@ ");
                Dumpable.dumpObject(out, item);
                continue;
            }
            out.append(' ');
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out, nextIndent, item, new Object[0]);
        }
    }

    public static void dumpContainer(Appendable out, String indent, Container object, boolean last) throws IOException {
        out = DumpAppendable.ensure(out);
        Container container2 = object;
        ContainerLifeCycle containerLifeCycle = container2 instanceof ContainerLifeCycle ? (ContainerLifeCycle)container2 : null;
        Iterator<Object> i = container2.getBeans().iterator();
        while (i.hasNext()) {
            Object bean = i.next();
            if (container2 instanceof DumpableContainer && !((DumpableContainer)((Object)container2)).isDumpable(bean)) continue;
            String nextIndent = indent + (i.hasNext() || !last ? "|  " : "   ");
            out.append(indent).append('+');
            if (bean instanceof LifeCycle) {
                if (container2.isManaged(bean)) {
                    out.append('=');
                } else if (containerLifeCycle != null && containerLifeCycle.isAuto(bean)) {
                    out.append('?');
                } else {
                    out.append('~');
                }
            } else if (containerLifeCycle != null && containerLifeCycle.isUnmanaged(bean)) {
                out.append('~');
            } else {
                out.append('-');
            }
            if (DumpAppendable.hasVisited(out, bean)) {
                out.append("@ ");
                Dumpable.dumpObject(out, bean);
                continue;
            }
            out.append(' ');
            if (bean instanceof Dumpable) {
                ((Dumpable)bean).dump(out, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out, nextIndent, bean, new Object[0]);
        }
    }

    public static void dumpIterable(Appendable out, String indent, Iterable<?> iterable, boolean last) throws IOException {
        out = DumpAppendable.ensure(out);
        Iterator<?> i = iterable.iterator();
        while (i.hasNext()) {
            Object item = i.next();
            if (Objects.equals(item, iterable)) {
                return;
            }
            String nextIndent = indent + (i.hasNext() || !last ? "|  " : "   ");
            out.append(indent).append("+: ");
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out, nextIndent, item, new Object[0]);
        }
    }

    public static void dumpMapEntries(Appendable out, String indent, Map<?, ?> map, boolean last) throws IOException {
        out = DumpAppendable.ensure(out);
        Iterator<Map.Entry<?, ?>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<?, ?> entry = i.next();
            String nextIndent = indent + (i.hasNext() || !last ? "|  " : "   ");
            out.append(indent).append("+@ ").append(String.valueOf(entry.getKey())).append(" = ");
            Object item = entry.getValue();
            if (item instanceof Dumpable) {
                ((Dumpable)item).dump(out, nextIndent);
                continue;
            }
            Dumpable.dumpObjects(out, nextIndent, item, new Object[0]);
        }
    }

    public static Dumpable named(final String name, Object object) {
        if (object instanceof Dumpable) {
            final Dumpable dumpable = (Dumpable)object;
            return new Dumpable(){

                @Override
                public String dumpSelf() {
                    return name + ": " + dumpable.dumpSelf();
                }

                @Override
                public void dump(Appendable out, String indent) throws IOException {
                    out.append(name).append(": ");
                    dumpable.dump(out, indent);
                }
            };
        }
        return (out, indent) -> {
            out.append(name).append(": ");
            Dumpable.dumpObjects(out, indent, object, new Object[0]);
        };
    }

    public static class DumpAppendable
    implements Appendable {
        private final Appendable _appendable;
        private final Set<Object> _visited = Collections.newSetFromMap(new IdentityHashMap());

        public DumpAppendable() {
            this(null);
        }

        public DumpAppendable(Appendable out) {
            this._appendable = Objects.requireNonNullElseGet(out, StringBuilder::new);
        }

        public static DumpAppendable ensure(Appendable out) {
            DumpAppendable da;
            return out instanceof DumpAppendable ? (da = (DumpAppendable)out) : new DumpAppendable(out);
        }

        public static void visit(Appendable out, Object item) {
            if (out instanceof DumpAppendable) {
                DumpAppendable dumpAppendable = (DumpAppendable)out;
                dumpAppendable._visited.add(item);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static boolean hasVisited(Appendable out, Object item) {
            if (!(out instanceof DumpAppendable)) return false;
            DumpAppendable dumpAppendable = (DumpAppendable)out;
            if (!dumpAppendable._visited.contains(item)) return false;
            return true;
        }

        @Override
        public Appendable append(CharSequence csq) throws IOException {
            return this._appendable.append(csq);
        }

        @Override
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            return this._appendable.append(csq, start, end);
        }

        @Override
        public Appendable append(char c) throws IOException {
            return this._appendable.append(c);
        }

        public String toString() {
            return this._appendable.toString();
        }
    }

    public static interface DumpableContainer
    extends Dumpable {
        default public boolean isDumpable(Object o) {
            return true;
        }
    }
}

