/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.rowset;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.rowset.RowSetWriterFactory;
import org.apache.jena.riot.rowset.rw.RowSetWriterCSV;
import org.apache.jena.riot.rowset.rw.RowSetWriterJSON;
import org.apache.jena.riot.rowset.rw.RowSetWriterNone;
import org.apache.jena.riot.rowset.rw.RowSetWriterProtobuf;
import org.apache.jena.riot.rowset.rw.RowSetWriterTSV;
import org.apache.jena.riot.rowset.rw.RowSetWriterText;
import org.apache.jena.riot.rowset.rw.RowSetWriterThrift;
import org.apache.jena.riot.rowset.rw.RowSetWriterXML;

public class RowSetWriterRegistry {
    private static Map<Lang, RowSetWriterFactory> registry = new ConcurrentHashMap<Lang, RowSetWriterFactory>();
    private static boolean initialized = false;

    public static RowSetWriterFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void register(Lang lang, RowSetWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        RowSetWriterRegistry.register(ResultSetLang.RS_XML, RowSetWriterXML.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_JSON, RowSetWriterJSON.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_CSV, RowSetWriterCSV.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_TSV, RowSetWriterTSV.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_Thrift, RowSetWriterThrift.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_Protobuf, RowSetWriterProtobuf.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_Text, RowSetWriterText.factory);
        RowSetWriterRegistry.register(ResultSetLang.RS_None, RowSetWriterNone.factory);
    }
}

