/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.base.file;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentedMemBuffer {
    private static Logger log = LoggerFactory.getLogger(SegmentedMemBuffer.class);
    private static int DFT_CHUNK = 0x100000;
    private static int DFT_SEGMENTS = 1000;
    private final int CHUNK;
    private long dataLength = 0L;
    private List<byte[]> space = null;
    private boolean isOpen;
    private final boolean TRACKING = false;

    public SegmentedMemBuffer() {
        this(DFT_CHUNK);
    }

    public SegmentedMemBuffer(int chunk) {
        this.CHUNK = chunk;
        this.space = new ArrayList<byte[]>(DFT_SEGMENTS);
        this.isOpen = true;
    }

    public void open() {
        this.isOpen = true;
    }

    public boolean isOpen() {
        return this.space != null;
    }

    public int read(long posn, ByteBuffer bb) {
        this.checkOpen();
        this.checkPosition(posn);
        int len = bb.remaining();
        if (posn + this.dataLength > this.dataLength) {
            len = (int)(this.dataLength - posn);
        }
        this.arrayCopyOut(this.space, posn, bb);
        return len;
    }

    public int read(long posn, byte[] b) {
        return this.read$(posn, b, 0, b.length);
    }

    public int read(long posn, byte[] b, int start, int length) {
        return this.read$(posn, b, start, length);
    }

    private int read$(long posn, byte[] b, int start, int length) {
        this.checkOpen();
        if (posn >= this.dataLength) {
            return -1;
        }
        this.checkPosition(posn);
        if (length == 0) {
            return 0;
        }
        this.checkByteArray(b, start, length);
        int len = length;
        if (posn + (long)length > this.dataLength) {
            len = (int)(this.dataLength - posn);
        }
        this.arrayCopyOut(this.space, posn, b, start, len);
        return len;
    }

    public void write(long posn, ByteBuffer bb) {
        this.checkOpen();
        if (posn != this.dataLength) {
            this.checkPosition(posn);
        }
        this.arrayCopyIn(bb, this.space, posn);
    }

    public void write(long posn, byte[] b) {
        this.write$(posn, b, 0, b.length);
    }

    public void write(long posn, byte[] b, int start, int length) {
        this.write$(posn, b, start, length);
    }

    private void write$(long posn, byte[] b, int start, int length) {
        this.checkOpen();
        this.checkPosition(posn);
        if (length == 0) {
            return;
        }
        this.checkByteArray(b, start, length);
        this.arrayCopyIn(b, start, this.space, this.dataLength, length);
    }

    public void truncate(long length) {
        if (length < 0L) {
            IO.exception(String.format("truncate: bad length : %d", length));
        }
        this.checkOpen();
        this.dataLength = Math.min(this.dataLength, length);
    }

    public void sync() {
        this.checkOpen();
    }

    public void close() {
        if (!this.isOpen()) {
            return;
        }
        this.isOpen = false;
        this.space.clear();
        this.space = null;
    }

    public long length() {
        return this.dataLength;
    }

    private void checkOpen() {
        if (!this.isOpen) {
            IO.exception("Not open");
        }
    }

    private void checkPosition(long posn) {
        if (posn < 0L || posn > this.dataLength) {
            IO.exception(String.format("Position out of bounds: %d in [0,%d]", posn, this.dataLength));
        }
    }

    private void checkByteArray(byte[] b, int start, int length) {
        if (start < 0 || start >= b.length) {
            IO.exception(String.format("Start point out of bounds of byte array: %d in [0,%d)", start, b.length));
        }
        if (length < 0 || start + length > b.length) {
            IO.exception(String.format("Start/length out of bounds of byte array: %d/%d in [0,%d)", start, length, b.length));
        }
    }

    private int getSegment(long posn) {
        return (int)(posn / (long)this.CHUNK);
    }

    private int getOffset(long posn) {
        return (int)(posn % (long)this.CHUNK);
    }

    private void arrayCopyIn(byte[] src, int srcStart, List<byte[]> dest, long destStart, int length) {
        if (length == 0) {
            return;
        }
        int len = length;
        int srcPosn = srcStart;
        int seg = this.getSegment(destStart);
        int offset = this.getOffset(destStart);
        while (len > 0) {
            int z = Math.min(len, this.CHUNK - offset);
            if (seg >= dest.size()) {
                byte[] buffer = new byte[this.CHUNK];
                this.space.add(buffer);
            }
            System.arraycopy(src, srcPosn, dest.get(seg), offset, z);
            srcPosn += z;
            len -= z;
            ++seg;
            offset += z;
            offset %= this.CHUNK;
        }
        this.dataLength = Math.max(this.dataLength, destStart + (long)length);
    }

    private void arrayCopyOut(List<byte[]> src, long srcStart, byte[] dest, int destStart, int length) {
        int len = length;
        len = Math.min(len, (int)(this.dataLength - srcStart));
        int dstPosn = destStart;
        int seg = this.getSegment(srcStart);
        int offset = this.getOffset(srcStart);
        while (len > 0) {
            int z = Math.min(len, this.CHUNK - offset);
            System.arraycopy(src.get(seg), offset, dest, dstPosn, z);
            dstPosn += z;
            len -= z;
            ++seg;
            offset += z;
            offset %= this.CHUNK;
        }
    }

    private void arrayCopyIn(ByteBuffer bb, List<byte[]> dest, long destStart) {
        if (bb.remaining() == 0) {
            return;
        }
        int length = bb.remaining();
        int len = bb.remaining();
        int srcPosn = bb.position();
        int seg = this.getSegment(destStart);
        int offset = this.getOffset(destStart);
        while (len > 0) {
            int z = Math.min(len, this.CHUNK - offset);
            if (seg >= dest.size()) {
                byte[] buffer = new byte[this.CHUNK];
                this.space.add(buffer);
            }
            byte[] bytes = dest.get(seg);
            bb.get(bytes, offset, z);
            srcPosn += z;
            len -= z;
            ++seg;
            offset += z;
            offset %= this.CHUNK;
        }
        this.dataLength = Math.max(this.dataLength, destStart + (long)length);
    }

    private void arrayCopyOut(List<byte[]> src, long srcStart, ByteBuffer bb) {
        int len = bb.remaining();
        len = Math.min(len, (int)(this.dataLength - srcStart));
        int dstPosn = bb.position();
        int seg = this.getSegment(srcStart);
        int offset = this.getOffset(srcStart);
        while (len > 0) {
            int z = Math.min(len, this.CHUNK - offset);
            byte[] bytes = src.get(seg);
            bb.put(bytes, offset, z);
            dstPosn += z;
            len -= z;
            ++seg;
            offset += z;
            offset %= this.CHUNK;
        }
    }

    private void log(String fmt, Object ... args) {
    }
}

