/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.Script;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;

@JsonpDeserializable
public class ScriptedMetricAggregation
extends MetricAggregationBase
implements AggregationVariant {
    @Nullable
    private final Script combineScript;
    @Nullable
    private final Script initScript;
    @Nullable
    private final Script mapScript;
    private final Map<String, JsonData> params;
    @Nullable
    private final Script reduceScript;
    public static final JsonpDeserializer<ScriptedMetricAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ScriptedMetricAggregation::setupScriptedMetricAggregationDeserializer);

    private ScriptedMetricAggregation(Builder builder) {
        super(builder);
        this.combineScript = builder.combineScript;
        this.initScript = builder.initScript;
        this.mapScript = builder.mapScript;
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.reduceScript = builder.reduceScript;
    }

    public static ScriptedMetricAggregation of(Function<Builder, ObjectBuilder<ScriptedMetricAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.ScriptedMetric;
    }

    @Nullable
    public final Script combineScript() {
        return this.combineScript;
    }

    @Nullable
    public final Script initScript() {
        return this.initScript;
    }

    @Nullable
    public final Script mapScript() {
        return this.mapScript;
    }

    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nullable
    public final Script reduceScript() {
        return this.reduceScript;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.combineScript != null) {
            generator.writeKey("combine_script");
            this.combineScript.serialize(generator, mapper);
        }
        if (this.initScript != null) {
            generator.writeKey("init_script");
            this.initScript.serialize(generator, mapper);
        }
        if (this.mapScript != null) {
            generator.writeKey("map_script");
            this.mapScript.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.params.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.reduceScript != null) {
            generator.writeKey("reduce_script");
            this.reduceScript.serialize(generator, mapper);
        }
    }

    protected static void setupScriptedMetricAggregationDeserializer(ObjectDeserializer<Builder> op) {
        MetricAggregationBase.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::combineScript, Script._DESERIALIZER, "combine_script");
        op.add(Builder::initScript, Script._DESERIALIZER, "init_script");
        op.add(Builder::mapScript, Script._DESERIALIZER, "map_script");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::reduceScript, Script._DESERIALIZER, "reduce_script");
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements ObjectBuilder<ScriptedMetricAggregation> {
        @Nullable
        private Script combineScript;
        @Nullable
        private Script initScript;
        @Nullable
        private Script mapScript;
        @Nullable
        private Map<String, JsonData> params;
        @Nullable
        private Script reduceScript;

        public final Builder combineScript(@Nullable Script value) {
            this.combineScript = value;
            return this;
        }

        public final Builder combineScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.combineScript(fn.apply(new Script.Builder()).build());
        }

        public final Builder initScript(@Nullable Script value) {
            this.initScript = value;
            return this;
        }

        public final Builder initScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.initScript(fn.apply(new Script.Builder()).build());
        }

        public final Builder mapScript(@Nullable Script value) {
            this.mapScript = value;
            return this;
        }

        public final Builder mapScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.mapScript(fn.apply(new Script.Builder()).build());
        }

        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        public final Builder reduceScript(@Nullable Script value) {
            this.reduceScript = value;
            return this;
        }

        public final Builder reduceScript(Function<Script.Builder, ObjectBuilder<Script>> fn) {
            return this.reduceScript(fn.apply(new Script.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ScriptedMetricAggregation build() {
            this._checkSingleUse();
            return new ScriptedMetricAggregation(this);
        }
    }
}

