/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.processor;

import jakarta.inject.Inject;
import org.apache.james.imap.api.display.HumanReadableText;
import org.apache.james.imap.api.message.response.StatusResponseFactory;
import org.apache.james.imap.api.process.ImapProcessor;
import org.apache.james.imap.api.process.ImapSession;
import org.apache.james.imap.main.PathConverter;
import org.apache.james.imap.message.request.RenameRequest;
import org.apache.james.imap.processor.AbstractMailboxProcessor;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.exception.MailboxExistsException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.exception.TooLongMailboxNameException;
import org.apache.james.mailbox.model.MailboxPath;
import org.apache.james.metrics.api.MetricFactory;
import org.apache.james.util.MDCBuilder;
import org.apache.james.util.ReactorUtils;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;

public class RenameProcessor
extends AbstractMailboxProcessor<RenameRequest> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RenameProcessor.class);
    private final PathConverter.Factory pathConverterFactory;

    @Inject
    public RenameProcessor(MailboxManager mailboxManager, StatusResponseFactory factory, MetricFactory metricFactory, PathConverter.Factory pathConverterFactory) {
        super(RenameRequest.class, mailboxManager, factory, metricFactory);
        this.pathConverterFactory = pathConverterFactory;
    }

    @Override
    protected Mono<Void> processRequestReactive(RenameRequest request, ImapSession session, ImapProcessor.Responder responder) {
        try {
            PathConverter pathConverter = this.pathConverterFactory.forSession(session);
            MailboxPath existingPath = pathConverter.buildFullPath(request.getExistingName());
            MailboxPath newPath = pathConverter.buildFullPath(request.getNewName());
            MailboxManager mailboxManager = this.getMailboxManager();
            MailboxSession mailboxsession = session.getMailboxSession();
            return Mono.from((Publisher)mailboxManager.renameMailboxReactive(existingPath, newPath, MailboxManager.RenameOption.NONE, mailboxsession)).then(this.createInboxIfNeeded(existingPath, mailboxsession)).then(Mono.fromRunnable(() -> this.okComplete(request, responder))).onErrorResume(MailboxExistsException.class, e -> {
                this.no(request, responder, HumanReadableText.MAILBOX_EXISTS);
                return ReactorUtils.logAsMono(() -> LOGGER.debug("Rename from {} to {} failed because the target mailbox exists", new Object[]{existingPath, newPath, e}));
            }).onErrorResume(MailboxNotFoundException.class, e -> {
                this.no(request, responder, HumanReadableText.MAILBOX_NOT_FOUND);
                return ReactorUtils.logAsMono(() -> LOGGER.debug("Rename from {} to {} failed because the source mailbox doesn't exist", new Object[]{existingPath, newPath, e}));
            }).onErrorResume(TooLongMailboxNameException.class, e -> {
                this.taggedBad(request, responder, HumanReadableText.FAILURE_MAILBOX_NAME);
                return ReactorUtils.logAsMono(() -> LOGGER.debug("The mailbox name length is over limit: {}", (Object)newPath.getName(), e));
            }).onErrorResume(TooLongMailboxNameException.class, e -> {
                this.no(request, responder, HumanReadableText.GENERIC_FAILURE_DURING_PROCESSING);
                return ReactorUtils.logAsMono(() -> LOGGER.error("Rename from {} to {} failed", new Object[]{existingPath, newPath, e}));
            }).then(this.unsolicitedResponses(session, responder, false));
        }
        catch (Exception e2) {
            return Mono.error((Throwable)e2);
        }
    }

    private Mono<Void> createInboxIfNeeded(MailboxPath existingPath, MailboxSession session) {
        if (!existingPath.getName().equalsIgnoreCase("INBOX")) {
            return Mono.empty();
        }
        return Mono.from((Publisher)this.getMailboxManager().mailboxExists(existingPath, session)).flatMap(exisits -> {
            if (exisits.booleanValue()) {
                return Mono.empty();
            }
            return Mono.from((Publisher)this.getMailboxManager().createMailboxReactive(existingPath, session));
        }).then();
    }

    @Override
    protected MDCBuilder mdc(RenameRequest request) {
        return MDCBuilder.create().addToContext("action", "RENAME").addToContext("existingName", request.getExistingName()).addToContext("newName", request.getNewName());
    }
}

