/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.smtpserver;

import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.core.MaybeSender;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.protocols.api.ProtocolSession;
import org.apache.james.protocols.api.Response;
import org.apache.james.protocols.api.handler.ExtensibleHandler;
import org.apache.james.protocols.api.handler.LineHandler;
import org.apache.james.protocols.api.handler.WiringException;
import org.apache.james.protocols.netty.CommandInjectionDetectedException;
import org.apache.james.protocols.smtp.MailEnvelope;
import org.apache.james.protocols.smtp.SMTPResponse;
import org.apache.james.protocols.smtp.SMTPSession;
import org.apache.james.protocols.smtp.core.AbstractHookableCmdHandler;
import org.apache.james.protocols.smtp.core.DataLineFilter;
import org.apache.james.protocols.smtp.core.SMTPMDCContextFactory;
import org.apache.james.protocols.smtp.dsn.DSNStatus;
import org.apache.james.protocols.smtp.hook.Hook;
import org.apache.james.protocols.smtp.hook.HookResult;
import org.apache.james.protocols.smtp.hook.HookResultHook;
import org.apache.james.protocols.smtp.hook.MessageHook;
import org.apache.james.server.core.MailImpl;
import org.apache.james.server.core.MimeMessageInputStream;
import org.apache.james.server.core.MimeMessageInputStreamSource;
import org.apache.james.server.core.MimeMessageSource;
import org.apache.james.smtpserver.ExtendedSMTPSession;
import org.apache.james.smtpserver.JamesMessageHook;
import org.apache.james.smtpserver.SMTPConstants;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLineJamesMessageHookHandler
implements DataLineFilter,
ExtensibleHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataLineJamesMessageHookHandler.class);
    public static final boolean DETECT_SMTP_SMUGGLING = System.getProperty("james.prevent.smtp.smuggling", "true").equals("true");
    private List<JamesMessageHook> messageHandlers;
    private List<HookResultHook> rHooks;
    private List<MessageHook> mHandlers;

    private static void detectSMTPSmuggling(byte[] line) {
        if (DETECT_SMTP_SMUGGLING && (line.length < 2 || line[line.length - 2] != 13 || line[line.length - 1] != 10)) {
            throw new CommandInjectionDetectedException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public Response onLine(SMTPSession session, byte[] line, LineHandler<SMTPSession> next) {
        ExtendedSMTPSession extendedSMTPSession = (ExtendedSMTPSession)session;
        MimeMessageInputStreamSource mmiss = extendedSMTPSession.getMimeMessageWriter();
        try {
            OutputStream out = mmiss.getWritableOutputStream();
            DataLineJamesMessageHookHandler.detectSMTPSmuggling(line);
            if (line.length == 3 && line[0] == 46) {
                String mailName = mmiss.getSourceId();
                try (Closeable closeable = SMTPMDCContextFactory.forSession((SMTPSession)session).addToContext("mail", mailName).build();){
                    Response response;
                    out.flush();
                    out.close();
                    MailImpl mail = DataLineJamesMessageHookHandler.createMail(session, mailName);
                    session.setAttachment(SMTPConstants.MAIL, (Object)mail, ProtocolSession.State.Transaction);
                    try {
                        mail.setMessageContent((MimeMessageSource)mmiss);
                        Response response2 = this.processExtensions(session, (Mail)mail, mmiss);
                        session.popLineHandler();
                        response = response2;
                    }
                    catch (MessagingException e) {
                        SMTPResponse sMTPResponse;
                        block18: {
                            LOGGER.info("Unexpected error handling DATA stream", (Throwable)e);
                            sMTPResponse = new SMTPResponse("451", (CharSequence)"Unexpected error handling DATA stream.");
                            LifecycleUtil.dispose((Object)mmiss);
                            LifecycleUtil.dispose((Object)mail);
                            if (closeable == null) break block18;
                            closeable.close();
                        }
                        return sMTPResponse;
                        {
                            catch (Throwable throwable) {
                                LifecycleUtil.dispose((Object)mmiss);
                                LifecycleUtil.dispose((Object)mail);
                                throw throwable;
                            }
                        }
                    }
                    LifecycleUtil.dispose((Object)mmiss);
                    LifecycleUtil.dispose((Object)mail);
                    return response;
                }
            }
            if (line[0] == 46 && line[1] == 46) {
                out.write(line, 1, line.length - 1);
            } else {
                out.write(line);
            }
        }
        catch (IOException e) {
            LifecycleUtil.dispose((Object)mmiss);
            SMTPResponse response = new SMTPResponse("451", (CharSequence)(DSNStatus.getStatus((int)4, (String)"0.0") + " Error processing message: " + e.getMessage()));
            response.setEndSession(true);
            session.popLineHandler();
            LOGGER.error("Unknown error occurred while processing DATA.", (Throwable)e);
            return response;
        }
        catch (CommandInjectionDetectedException e) {
            LifecycleUtil.dispose((Object)mmiss);
            SMTPResponse response = new SMTPResponse("500", (CharSequence)(DSNStatus.getStatus((int)5, (String)"0.0") + " line delimiter must be CRLF"));
            response.setEndSession(true);
            session.popLineHandler();
            LOGGER.info("Use of CRLF, which might indicate SMTP smuggling attempt");
            return response;
        }
        return null;
    }

    private static MailImpl createMail(SMTPSession session, String mailName) {
        List recipientCollection = (List)session.getAttachment(SMTPSession.RCPT_LIST, ProtocolSession.State.Transaction).orElse(ImmutableList.of());
        MaybeSender sender = session.getAttachment(SMTPSession.SENDER, ProtocolSession.State.Transaction).orElse(MaybeSender.nullSender());
        return MailImpl.builder().name(mailName).sender(sender).addRecipients((Collection)recipientCollection).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Response processExtensions(SMTPSession session, Mail mail, MimeMessageInputStreamSource mmiss) {
        if (mail != null && this.messageHandlers != null) {
            try {
                OutputStream out = mmiss.getWritableOutputStream();
                for (MessageHook rawHandler : this.mHandlers) {
                    SMTPResponse response;
                    LOGGER.debug("executing james message handler {}", (Object)rawHandler);
                    long start = System.currentTimeMillis();
                    HookResult hRes = rawHandler.onMessage(session, (MailEnvelope)new MailToMailEnvelopeWrapper(mail, out));
                    long executionTime = System.currentTimeMillis() - start;
                    if (this.rHooks != null) {
                        for (HookResultHook rHook : this.rHooks) {
                            LOGGER.debug("executing hook {}", (Object)rHook);
                            hRes = rHook.onHookResult(session, hRes, executionTime, (Hook)rawHandler);
                        }
                    }
                    if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                    SMTPResponse sMTPResponse = response;
                    return sMTPResponse;
                }
                SMTPResponse sMTPResponse = this.executeJamesMessageHooks(session, mail);
                return sMTPResponse;
            }
            finally {
                LifecycleUtil.dispose((Object)mail);
                mail = null;
                session.resetState();
            }
        }
        return null;
    }

    protected SMTPResponse executeJamesMessageHooks(SMTPSession session, Mail mail) {
        if (this.messageHandlers != null) {
            for (JamesMessageHook messageHandler : this.messageHandlers) {
                SMTPResponse response;
                LOGGER.debug("executing james message handler {}", (Object)messageHandler);
                long start = System.currentTimeMillis();
                HookResult hRes = messageHandler.onMessage(session, mail);
                long executionTime = System.currentTimeMillis() - start;
                if (this.rHooks != null) {
                    for (HookResultHook rHook : this.rHooks) {
                        LOGGER.debug("executing hook {}", (Object)rHook);
                        hRes = rHook.onHookResult(session, hRes, executionTime, (Hook)messageHandler);
                    }
                }
                if ((response = AbstractHookableCmdHandler.calcDefaultSMTPResponse((HookResult)hRes)) == null) continue;
                return response;
            }
        }
        return null;
    }

    public void wireExtensions(Class<?> interfaceName, List<?> extension) throws WiringException {
        if (JamesMessageHook.class.equals(interfaceName)) {
            this.messageHandlers = extension;
            if (this.messageHandlers == null || this.messageHandlers.size() == 0) {
                throw new WiringException("No messageHandler configured");
            }
        } else if (MessageHook.class.equals(interfaceName)) {
            this.mHandlers = extension;
        } else if (HookResultHook.class.equals(interfaceName)) {
            this.rHooks = extension;
        }
    }

    public List<Class<?>> getMarkerInterfaces() {
        LinkedList classes = new LinkedList();
        classes.add(JamesMessageHook.class);
        classes.add(MessageHook.class);
        classes.add(HookResultHook.class);
        return classes;
    }

    protected static class MailToMailEnvelopeWrapper
    implements MailEnvelope {
        private final Mail mail;
        private final OutputStream out;

        public MailToMailEnvelopeWrapper(Mail mail, OutputStream out) {
            this.mail = mail;
            this.out = out;
        }

        public InputStream getMessageInputStream() throws IOException {
            try {
                return new MimeMessageInputStream(this.mail.getMessage());
            }
            catch (MessagingException e) {
                throw new IOException("Unable to get inputstream for message", e);
            }
        }

        public OutputStream getMessageOutputStream() throws IOException {
            return this.out;
        }

        public List<MailAddress> getRecipients() {
            return ImmutableList.copyOf((Collection)this.mail.getRecipients());
        }

        public MaybeSender getMaybeSender() {
            return this.mail.getMaybeSender();
        }

        public long getSize() {
            try {
                return this.mail.getMessageSize();
            }
            catch (MessagingException e) {
                return -1L;
            }
        }
    }
}

