/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.offheap.bytez.onheap;

import org.nustaq.offheap.bytez.BasicBytez;
import org.nustaq.offheap.bytez.Bytez;
import org.nustaq.offheap.bytez.malloc.MallocBytez;
import org.nustaq.serialization.util.FSTUtil;
import sun.misc.Unsafe;

public class HeapBytez
implements Bytez {
    static Unsafe unsafe = FSTUtil.getUnsafe();
    static long byteoff = FSTUtil.bufoff;
    static long caoff = FSTUtil.choff;
    static long saoff = FSTUtil.choff;
    static long iaoff = FSTUtil.intoff;
    static long laoff = FSTUtil.longoff;
    static long daoff = FSTUtil.doubleoff;
    static long faoff = FSTUtil.floatoff;
    byte[] base;
    long off;
    long len;
    int hash;

    private void checkIndex(long index, int len) {
    }

    public HeapBytez(byte[] base) {
        this(base, 0L);
    }

    public HeapBytez(int size) {
        this(new byte[size], 0L);
    }

    public HeapBytez(byte[] base, long offIndex) {
        this(base, offIndex, (long)base.length - offIndex);
    }

    public HeapBytez(byte[] base, long offIndex, long len) {
        this.setBase(base, offIndex, len);
    }

    public void setBase(byte[] base, long offIndex, long len) {
        this.base = base;
        this.off = byteoff + offIndex;
        this.len = len;
    }

    @Override
    public HeapBytez slice(long off, int len) {
        if (off + (long)len >= (long)this.base.length) {
            throw new RuntimeException("invalid slice " + off + ":" + len + " mylen:" + this.base.length);
        }
        return new HeapBytez(this.base, off, len);
    }

    @Override
    public byte get(long byteIndex) {
        this.checkIndex(byteIndex, 1);
        return unsafe.getByte(this.base, this.off + byteIndex);
    }

    @Override
    public boolean getBool(long byteIndex) {
        this.checkIndex(byteIndex, 1);
        return unsafe.getByte(this.base, this.off + byteIndex) != 0;
    }

    @Override
    public char getChar(long byteIndex) {
        this.checkIndex(byteIndex, 2);
        return unsafe.getChar(this.base, this.off + byteIndex);
    }

    @Override
    public short getShort(long byteIndex) {
        this.checkIndex(byteIndex, 2);
        return unsafe.getShort(this.base, this.off + byteIndex);
    }

    @Override
    public int getInt(long byteIndex) {
        this.checkIndex(byteIndex, 4);
        int res = unsafe.getInt(this.base, this.off + byteIndex);
        return res;
    }

    @Override
    public long getLong(long byteIndex) {
        this.checkIndex(byteIndex, 8);
        return unsafe.getLong(this.base, this.off + byteIndex);
    }

    @Override
    public float getFloat(long byteIndex) {
        this.checkIndex(byteIndex, 4);
        return unsafe.getFloat(this.base, this.off + byteIndex);
    }

    @Override
    public double getDouble(long byteIndex) {
        this.checkIndex(byteIndex, 8);
        return unsafe.getDouble(this.base, this.off + byteIndex);
    }

    @Override
    public void put(long byteIndex, byte value) {
        this.checkIndex(byteIndex, 1);
        unsafe.putByte(this.base, this.off + byteIndex, value);
    }

    @Override
    public void putBool(long byteIndex, boolean val) {
        this.checkIndex(byteIndex, 1);
        this.put(byteIndex, (byte)(val ? 1 : 0));
    }

    @Override
    public void putChar(long byteIndex, char c) {
        this.checkIndex(byteIndex, 2);
        unsafe.putChar(this.base, this.off + byteIndex, c);
    }

    @Override
    public void putShort(long byteIndex, short s2) {
        this.checkIndex(byteIndex, 2);
        unsafe.putShort(this.base, this.off + byteIndex, s2);
    }

    @Override
    public void putInt(long byteIndex, int i) {
        this.checkIndex(byteIndex, 4);
        unsafe.putInt(this.base, this.off + byteIndex, i);
    }

    @Override
    public void putLong(long byteIndex, long l) {
        this.checkIndex(byteIndex, 8);
        unsafe.putLong(this.base, this.off + byteIndex, l);
    }

    @Override
    public void putFloat(long byteIndex, float f) {
        this.checkIndex(byteIndex, 4);
        unsafe.putFloat(this.base, this.off + byteIndex, f);
    }

    @Override
    public void putDouble(long byteIndex, double d) {
        this.checkIndex(byteIndex, 8);
        unsafe.putDouble(this.base, this.off + byteIndex, d);
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public void getArr(long byteIndex, byte[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, this.off + (long)elemoff, numElems);
    }

    @Override
    public void getCharArr(long byteIndex, char[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, caoff + (long)(elemoff * 2) + this.off - byteoff, numElems * 2);
    }

    @Override
    public void getShortArr(long byteIndex, short[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, saoff + (long)(elemoff * 2) + this.off - byteoff, numElems * 2);
    }

    @Override
    public void getIntArr(long byteIndex, int[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, iaoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 4);
    }

    @Override
    public void getLongArr(long byteIndex, long[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, laoff + (long)(elemoff * 8) + this.off - byteoff, numElems * 8);
    }

    @Override
    public void getFloatArr(long byteIndex, float[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, faoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 4);
    }

    @Override
    public void getDoubleArr(long byteIndex, double[] target, int elemoff, int numElems) {
        unsafe.copyMemory(this.base, this.off + byteIndex, target, daoff + (long)(elemoff * 4) + this.off - byteoff, numElems * 8);
    }

    @Override
    public void getBooleanArr(long byteIndex, boolean[] target, int elemoff, int numElems) {
        for (int i = 0; i < numElems; ++i) {
            target[elemoff + i] = this.getBool(byteIndex + (long)i);
        }
    }

    @Override
    public void set(long byteIndex, byte[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems);
        unsafe.copyMemory(source, this.off + (long)elemoff, this.base, this.off + byteIndex, numElems);
    }

    @Override
    public void setChar(long byteIndex, char[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 2);
        unsafe.copyMemory(source, caoff + this.off - byteoff + (long)(elemoff * 2), this.base, this.off + byteIndex, numElems * 2);
    }

    @Override
    public void setShort(long byteIndex, short[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 2);
        unsafe.copyMemory(source, caoff + this.off - byteoff + (long)(elemoff * 2), this.base, this.off + byteIndex, numElems * 2);
    }

    @Override
    public void setInt(long byteIndex, int[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 4);
        unsafe.copyMemory(source, iaoff + this.off - byteoff + (long)(elemoff * 4), this.base, this.off + byteIndex, numElems * 4);
    }

    @Override
    public void setLong(long byteIndex, long[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 8);
        unsafe.copyMemory(source, laoff + this.off - byteoff + (long)(elemoff * 8), this.base, this.off + byteIndex, numElems * 8);
    }

    @Override
    public void setFloat(long byteIndex, float[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 4);
        unsafe.copyMemory(source, faoff + this.off - byteoff + (long)(elemoff * 4), this.base, this.off + byteIndex, numElems * 4);
    }

    @Override
    public void setDouble(long byteIndex, double[] source, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems * 8);
        unsafe.copyMemory(source, daoff + this.off - byteoff + (long)(elemoff * 8), this.base, this.off + byteIndex, numElems * 8);
    }

    @Override
    public void setBoolean(long byteIndex, boolean[] o, int elemoff, int numElems) {
        this.checkIndex(byteIndex, numElems);
        for (int i = 0; i < numElems; ++i) {
            this.put(byteIndex + (long)i, (byte)(o[i + elemoff] ? 1 : 0));
        }
    }

    @Override
    public void copyTo(BasicBytez other, long otherByteIndex, long myByteIndex, long lenBytes) {
        if (lenBytes == 0L) {
            return;
        }
        this.checkIndex(myByteIndex, (int)lenBytes);
        if (other instanceof HeapBytez) {
            HeapBytez hp = (HeapBytez)other;
            unsafe.copyMemory(this.base, this.off + myByteIndex, hp.base, hp.off + otherByteIndex, lenBytes);
        } else if (other instanceof MallocBytez) {
            MallocBytez mb = (MallocBytez)other;
            unsafe.copyMemory(this.base, this.off + myByteIndex, null, otherByteIndex + mb.getBaseAdress(), lenBytes);
        } else {
            for (long i = 0L; i < lenBytes; ++i) {
                other.put(otherByteIndex + i, this.get(myByteIndex + i));
            }
        }
    }

    @Override
    public BasicBytez newInstance(long size) {
        return new HeapBytez(new byte[(int)size]);
    }

    @Override
    public boolean compareAndSwapInt(long offset, int expect, int newVal) {
        return unsafe.compareAndSwapInt(this.base, this.off + offset, expect, newVal);
    }

    @Override
    public boolean compareAndSwapLong(long offset, long expect, long newVal) {
        return unsafe.compareAndSwapLong(this.base, this.off + offset, expect, newVal);
    }

    @Override
    public byte[] toBytes(long startIndex, int len) {
        byte[] res = new byte[len];
        System.arraycopy(this.base, (int)(this.off - FSTUtil.bufoff) + (int)startIndex, res, 0, len);
        return res;
    }

    @Override
    public byte[] asByteArray() {
        return this.base;
    }

    @Override
    public int getBAOffsetIndex() {
        return (int)(this.off - FSTUtil.bufoff);
    }

    @Override
    public int getBALength() {
        return 0;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0 && this.length() > 0L) {
            int i = 0;
            while ((long)i < this.length()) {
                h2 = 31 * h2 + this.get(i);
                ++i;
            }
            this.hash = h2;
        }
        return h2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof HeapBytez) {
            HeapBytez other = (HeapBytez)obj;
            if (other.length() != this.length()) {
                return false;
            }
            int i = 0;
            while ((long)i < this.length()) {
                if (this.get(i) != other.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean getBoolVolatile(long byteIndex) {
        return this.getVolatile(byteIndex) != 0;
    }

    @Override
    public byte getVolatile(long byteIndex) {
        return unsafe.getByteVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public char getCharVolatile(long byteIndex) {
        return unsafe.getCharVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public short getShortVolatile(long byteIndex) {
        return unsafe.getShortVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public int getIntVolatile(long byteIndex) {
        return unsafe.getIntVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public long getLongVolatile(long byteIndex) {
        return unsafe.getLongVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public float getFloatVolatile(long byteIndex) {
        return unsafe.getFloatVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public double getDoubleVolatile(long byteIndex) {
        return unsafe.getDoubleVolatile(this.base, this.off + byteIndex);
    }

    @Override
    public void putBoolVolatile(long byteIndex, boolean value) {
        this.putVolatile(byteIndex, (byte)(value ? 1 : 0));
    }

    @Override
    public void putVolatile(long byteIndex, byte value) {
        unsafe.putByteVolatile(this.base, this.off + byteIndex, value);
    }

    @Override
    public void putCharVolatile(long byteIndex, char c) {
        unsafe.putCharVolatile(this.base, this.off + byteIndex, c);
    }

    @Override
    public void putShortVolatile(long byteIndex, short s2) {
        unsafe.putShortVolatile(this.base, this.off + byteIndex, s2);
    }

    @Override
    public void putIntVolatile(long byteIndex, int i) {
        unsafe.putIntVolatile(this.base, this.off + byteIndex, i);
    }

    @Override
    public void putLongVolatile(long byteIndex, long l) {
        unsafe.putLongVolatile(this.base, this.off + byteIndex, l);
    }

    @Override
    public void putFloatVolatile(long byteIndex, float f) {
        unsafe.putFloatVolatile(this.base, this.off + byteIndex, f);
    }

    @Override
    public void putDoubleVolatile(long byteIndex, double d) {
        unsafe.putDoubleVolatile(this.base, this.off + byteIndex, d);
    }

    public byte[] getBase() {
        return this.base;
    }

    public long getOff() {
        return this.off;
    }

    public long getOffsetIndex() {
        return this.off - byteoff;
    }

    public String toString() {
        return "HeapBytez{base=" + this.base + ", off=" + this.off + ", len=" + this.len + '}';
    }
}

