/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.concurrent;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.commons.concurrent.IoTDBDaemonThreadFactory;
import org.apache.iotdb.commons.concurrent.IoTThreadFactory;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedScheduledExecutorService;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedSingleThreadExecutorService;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedSingleThreadScheduledExecutor;
import org.apache.iotdb.commons.concurrent.threadpool.WrappedThreadPoolExecutor;
import org.apache.thrift.server.TThreadPoolServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBThreadPoolFactory {
    private static final Logger logger = LoggerFactory.getLogger(IoTDBThreadPoolFactory.class);
    private static final String NEW_FIXED_THREAD_POOL_LOGGER_FORMAT = "new fixed thread pool: {}, thread number: {}";
    private static final String NEW_SINGLE_THREAD_POOL_LOGGER_FORMAT = "new single thread pool: {}";
    private static final String NEW_CACHED_THREAD_POOL_LOGGER_FORMAT = "new cached thread pool: {}";
    private static final String NEW_SINGLE_SCHEDULED_THREAD_POOL_LOGGER_FORMAT = "new single scheduled thread pool: {}";
    private static final String NEW_SCHEDULED_THREAD_POOL_LOGGER_FORMAT = "new scheduled thread pool: {}";
    private static final String NEW_SYNCHRONOUS_QUEUE_THREAD_POOL_LOGGER_FORMAT = "new SynchronousQueue thread pool: {}";
    private static final String NEW_THREAD_POOL_LOGGER_FORMAT = "new thread pool: {}";

    private IoTDBThreadPoolFactory() {
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName) {
        logger.info(NEW_FIXED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName, (Object)nThreads);
        return new WrappedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName, RejectedExecutionHandler handler) {
        logger.info(NEW_FIXED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName, (Object)nThreads);
        return new WrappedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName), poolName, handler);
    }

    public static ExecutorService newFixedThreadPoolWithDaemonThread(int nThreads, String poolName) {
        logger.info(NEW_FIXED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName, (Object)nThreads);
        return new WrappedSingleThreadExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName)), poolName);
    }

    public static ExecutorService newFixedThreadPool(int nThreads, String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_FIXED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName, (Object)nThreads);
        return new WrappedThreadPoolExecutor(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName, handler), poolName);
    }

    public static ExecutorService newSingleThreadExecutor(String poolName) {
        logger.info(NEW_SINGLE_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedSingleThreadExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName)), poolName);
    }

    public static ExecutorService newSingleThreadExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_SINGLE_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedSingleThreadExecutorService(new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ExecutorService newCachedThreadPool(String poolName) {
        logger.info(NEW_CACHED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService newCachedThreadPool(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_CACHED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new IoTThreadFactory(poolName, handler), poolName);
    }

    public static ExecutorService newCachedThreadPoolWithDaemon(String poolName) {
        logger.info(NEW_CACHED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new IoTDBDaemonThreadFactory(poolName), poolName);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName) {
        logger.info(NEW_SINGLE_SCHEDULED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedSingleThreadScheduledExecutor(new ScheduledThreadPoolExecutor(1, new IoTThreadFactory(poolName)), poolName);
    }

    public static ScheduledExecutorService newSingleThreadScheduledExecutor(String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_SINGLE_SCHEDULED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedSingleThreadScheduledExecutor(new ScheduledThreadPoolExecutor(1, new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName) {
        logger.info(NEW_SCHEDULED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName)), poolName);
    }

    public static ScheduledExecutorService newScheduledThreadPoolWithDaemon(int corePoolSize, String poolName) {
        logger.info(NEW_SCHEDULED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new IoTDBDaemonThreadFactory(poolName)), poolName);
    }

    public static ScheduledExecutorService newScheduledThreadPool(int corePoolSize, String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_SCHEDULED_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedScheduledExecutorService(Executors.newScheduledThreadPool(corePoolSize, new IoTThreadFactory(poolName, handler)), poolName);
    }

    public static ExecutorService newThreadPool(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, IoTThreadFactory ioTThreadFactory, String poolName) {
        logger.info(NEW_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        return new WrappedThreadPoolExecutor(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, ioTThreadFactory, poolName);
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName) {
        logger.info(NEW_SYNCHRONOUS_QUEUE_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new WrappedThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, (long)args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService createThriftRpcClientThreadPool(int minWorkerThreads, int maxWorkerThreads, int stopTimeoutVal, TimeUnit stopTimeoutUnit, String poolName) {
        logger.info(NEW_SYNCHRONOUS_QUEUE_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new WrappedThreadPoolExecutor(minWorkerThreads, maxWorkerThreads, (long)stopTimeoutVal, stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName), poolName);
    }

    public static ExecutorService createThriftRpcClientThreadPool(TThreadPoolServer.Args args, String poolName, Thread.UncaughtExceptionHandler handler) {
        logger.info(NEW_SYNCHRONOUS_QUEUE_THREAD_POOL_LOGGER_FORMAT, (Object)poolName);
        SynchronousQueue<Runnable> executorQueue = new SynchronousQueue<Runnable>();
        return new WrappedThreadPoolExecutor(args.minWorkerThreads, args.maxWorkerThreads, (long)args.stopTimeoutVal, args.stopTimeoutUnit, executorQueue, new IoTThreadFactory(poolName, handler), poolName);
    }
}

