/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.compressor.lz4;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.jpountz.lz4.LZ4BlockInputStream;
import net.jpountz.lz4.LZ4BlockOutputStream;
import net.jpountz.lz4.LZ4Compressor;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lz4Util {
    private static final Logger LOGGER = LoggerFactory.getLogger(Lz4Util.class);
    private static final int ARRAY_SIZE = 1024;

    public static byte[] compress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        LZ4Compressor compressor = LZ4Factory.fastestInstance().fastCompressor();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (LZ4BlockOutputStream lz4BlockOutputStream = new LZ4BlockOutputStream((OutputStream)outputStream, 1024, compressor);){
            lz4BlockOutputStream.write(bytes);
        }
        catch (IOException e) {
            LOGGER.error("compress bytes error", (Throwable)e);
        }
        return outputStream.toByteArray();
    }

    public static byte[] decompress(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes is null");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(1024);
        LZ4FastDecompressor decompressor = LZ4Factory.fastestInstance().fastDecompressor();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        try (LZ4BlockInputStream decompressedInputStream = new LZ4BlockInputStream((InputStream)inputStream, decompressor);){
            int count;
            byte[] buffer = new byte[1024];
            while ((count = decompressedInputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, count);
            }
        }
        catch (IOException e) {
            LOGGER.error("decompress bytes error", (Throwable)e);
        }
        return outputStream.toByteArray();
    }
}

