/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.google.common.collect.Lists;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.io.IOException;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.common.Result;
import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.manager.common.Utils;
import org.apache.ozhera.log.manager.common.utils.ManagerUtil;
import org.apache.ozhera.log.manager.dao.MilogLogstoreDao;
import org.apache.ozhera.log.manager.domain.EsCluster;
import org.apache.ozhera.log.manager.domain.SearchLog;
import org.apache.ozhera.log.manager.model.StatisticsQuery;
import org.apache.ozhera.log.manager.model.dto.EsStatisticsKeyWord;
import org.apache.ozhera.log.manager.model.pojo.MilogLogStoreDO;
import org.apache.ozhera.log.manager.model.vo.LogQuery;
import org.apache.ozhera.log.manager.service.StatisticsService;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.elasticsearch.search.aggregations.bucket.terms.ParsedStringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    private static final Logger log = LoggerFactory.getLogger(StatisticsServiceImpl.class);
    @Resource
    private MilogLogstoreDao logstoreDao;
    @Resource
    private EsCluster esCluster;
    @Resource
    private SearchLog searchLog;

    @Override
    public Result<Map<String, Long>> queryTailStatisticsByHour(StatisticsQuery statisticsQuery) throws IOException {
        MilogLogStoreDO milogLogstoreDO;
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        if (statisticsQuery.getStartTime() == null || statisticsQuery.getStartTime() == 0L) {
            statisticsQuery.setStartTime(Utils.getTodayTime().get("start"));
            statisticsQuery.setEndTime(Utils.getTodayTime().get("end"));
        }
        if ((milogLogstoreDO = this.logstoreDao.queryById(statisticsQuery.getLogstoreId())) == null) {
            return Result.success();
        }
        EsService esService = this.esCluster.getEsService(milogLogstoreDO.getEsClusterId());
        String esIndexName = milogLogstoreDO.getEsIndex();
        SearchSourceBuilder builder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").gte((Object)statisticsQuery.getStartTime()).lte((Object)statisticsQuery.getEndTime()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"logstore", (String)milogLogstoreDO.getLogstoreName()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"tail", (String)statisticsQuery.getTail()));
        DateHistogramAggregationBuilder aggregation = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)"agg").field("timestamp")).calendarInterval(DateHistogramInterval.hours((int)1)).format("yyyy-MM-dd HH:mm:ss")).timeZone(ZoneId.of("+08:00"))).minDocCount(0L);
        builder.query((QueryBuilder)boolQueryBuilder);
        builder.aggregation((AggregationBuilder)aggregation);
        SearchRequest searchRequest = new SearchRequest(new String[]{esIndexName});
        searchRequest.source(builder);
        SearchResponse searchResponse = esService.search(searchRequest);
        ParsedDateHistogram parsedDateHistogram = (ParsedDateHistogram)searchResponse.getAggregations().asMap().get("agg");
        for (Histogram.Bucket bucket : parsedDateHistogram.getBuckets()) {
            result.put(bucket.getKeyAsString(), bucket.getDocCount());
        }
        return Result.success(result);
    }

    @Override
    public Result<Map<String, Long>> queryStoreTopTailStatisticsByDay(StatisticsQuery statisticsQuery) throws IOException {
        MilogLogStoreDO logstoreDO;
        if (statisticsQuery.getStartTime() == null || statisticsQuery.getStartTime() == 0L) {
            statisticsQuery.setStartTime(Utils.getTodayTime().get("start"));
            statisticsQuery.setEndTime(Utils.getTodayTime().get("end"));
        }
        if ((logstoreDO = this.logstoreDao.queryById(statisticsQuery.getLogstoreId())) == null) {
            return Result.success();
        }
        SearchRequest searchRequest = new SearchRequest();
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from((Object)statisticsQuery.getStartTime()).to((Object)statisticsQuery.getEndTime()));
        boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"logstore", (String)logstoreDO.getLogstoreName()));
        TermsAggregationBuilder tailAggr = AggregationBuilders.terms((String)"tail");
        tailAggr.field("tail");
        tailAggr.order(BucketOrder.count((boolean)false));
        searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)tailAggr).size(0);
        searchRequest.source(searchSourceBuilder);
        searchRequest.indices(new String[]{logstoreDO.getEsIndex()});
        EsService esService = this.esCluster.getEsService(logstoreDO.getEsClusterId());
        SearchResponse searchResponse = esService.search(searchRequest);
        ParsedStringTerms aggregations = (ParsedStringTerms)searchResponse.getAggregations().get("tail");
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        for (Terms.Bucket bucket : aggregations.getBuckets()) {
            result.put(String.valueOf(bucket.getKey()), bucket.getDocCount());
        }
        return Result.success(result);
    }

    @Override
    public Result<Map<String, Long>> querySpaceTopStoreByDay(StatisticsQuery statisticsQuery) throws IOException {
        List<MilogLogStoreDO> logstoreList;
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        if (statisticsQuery.getStartTime() == null || statisticsQuery.getStartTime() == 0L) {
            statisticsQuery.setStartTime(Utils.getTodayTime().get("start"));
            statisticsQuery.setEndTime(Utils.getTodayTime().get("end"));
        }
        if (null != (logstoreList = this.logstoreDao.getMilogLogstoreBySpaceId(statisticsQuery.getSpaceId())) && logstoreList.size() > 0) {
            for (MilogLogStoreDO logstoreDO : logstoreList) {
                SearchRequest searchRequest = new SearchRequest();
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"timestamp").from((Object)statisticsQuery.getStartTime()).to((Object)statisticsQuery.getEndTime()));
                boolQueryBuilder.filter((QueryBuilder)QueryBuilders.termQuery((String)"logstore", (String)logstoreDO.getLogstoreName()));
                TermsAggregationBuilder tailAggr = AggregationBuilders.terms((String)"logstore");
                tailAggr.field("logstore");
                tailAggr.order(BucketOrder.count((boolean)false));
                searchSourceBuilder.query((QueryBuilder)boolQueryBuilder).aggregation((AggregationBuilder)tailAggr).size(0);
                searchRequest.source(searchSourceBuilder);
                searchRequest.indices(new String[]{logstoreDO.getEsIndex()});
                EsService esService = this.esCluster.getEsService(logstoreDO.getEsClusterId());
                SearchResponse searchResponse = esService.search(searchRequest);
                ParsedStringTerms aggregations = (ParsedStringTerms)searchResponse.getAggregations().get("logstore");
                for (Terms.Bucket bucket : aggregations.getBuckets()) {
                    result.put(String.valueOf(bucket.getKey()), bucket.getDocCount());
                }
            }
        }
        return Result.success(result);
    }

    @Override
    public Result<List<EsStatisticsKeyWord>> queryEsStatisticsRation(LogQuery logQuery) {
        ArrayList results = Lists.newArrayList();
        if (null == logQuery.getStoreId()) {
            return Result.failParam((String)"The storeId cannot be empty");
        }
        MilogLogStoreDO logStoreDO = this.logstoreDao.queryById(logQuery.getStoreId());
        if (null == logStoreDO) {
            return Result.fail((Integer)CommonError.NOT_EXISTS_DATA.getCode(), (String)"The store does not exist");
        }
        if (null == logStoreDO.getEsClusterId() || StringUtils.isEmpty((CharSequence)logStoreDO.getEsIndex())) {
            return Result.fail((Integer)CommonError.NOT_EXISTS_DATA.getCode(), (String)"ES index-related information does not exist");
        }
        EsService esService = this.esCluster.getEsService(logStoreDO.getEsClusterId());
        String esIndexName = logStoreDO.getEsIndex();
        List<String> keyColons = ManagerUtil.getKeyColonPrefix(logStoreDO.getKeyList());
        for (String field : keyColons) {
            EsStatisticsKeyWord esStatisticsKeyWord = new EsStatisticsKeyWord();
            esStatisticsKeyWord.setKey(field);
            try {
                String aggregationName = String.format("%s-%s", field, "static-name");
                BoolQueryBuilder boolQueryBuilder = this.searchLog.getQueryBuilder(logQuery, ManagerUtil.getKeyColonPrefix(logStoreDO.getKeyList()));
                SearchRequest searchRequest = new SearchRequest(new String[]{esIndexName});
                SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder();
                searchSourceBuilder.query((QueryBuilder)boolQueryBuilder);
                searchSourceBuilder.size(5);
                searchRequest.source(searchSourceBuilder);
                SearchResponse searchResponse = esService.search(searchRequest);
                SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
                sourceBuilder.query((QueryBuilder)boolQueryBuilder);
                sourceBuilder.aggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)aggregationName).field(field)).size(5).subAggregation((AggregationBuilder)AggregationBuilders.sum((String)"total").field(field)));
                sourceBuilder.sort(new FieldSortBuilder(field).order(SortOrder.DESC));
                SearchRequest aggregationRequest = new SearchRequest(new String[]{esIndexName});
                aggregationRequest.source(sourceBuilder);
                SearchResponse aggregationResponse = esService.search(aggregationRequest);
                if (null == aggregationResponse.getAggregations()) continue;
                Terms terms = (Terms)aggregationResponse.getAggregations().get(aggregationName);
                ArrayList staticsKeyWords = Lists.newArrayList();
                for (Terms.Bucket bucket : terms.getBuckets()) {
                    String fieldValue = bucket.getKeyAsString();
                    Sum sum = (Sum)bucket.getAggregations().get("total");
                    double total = sum.getValue();
                    double percentage = NumberUtil.div((double)total, (float)searchResponse.getHits().getTotalHits().value, (int)4);
                    EsStatisticsKeyWord.StatisticsRation statisticsKeyWord = new EsStatisticsKeyWord.StatisticsRation();
                    statisticsKeyWord.setValue(fieldValue);
                    statisticsKeyWord.setRation("" + percentage);
                    staticsKeyWords.add(statisticsKeyWord);
                }
                esStatisticsKeyWord.setStatisticsRation(staticsKeyWords);
                results.add(esStatisticsKeyWord);
            }
            catch (Exception e) {
                log.error("query es index exception,field:{},logQuery:{}", new Object[]{field, Constant.GSON.toJson((Object)logQuery), e});
            }
        }
        return Result.success((Object)results);
    }
}

