/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.job;

import cn.hutool.core.thread.ThreadUtil;
import com.xiaomi.youpin.docean.anno.Component;
import com.xiaomi.youpin.docean.plugin.config.anno.Value;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.ozhera.log.manager.service.impl.LogCountServiceImpl;
import org.apache.ozhera.log.utils.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component
public class TailLogCountJob {
    private static final Logger log = LoggerFactory.getLogger(TailLogCountJob.class);
    @Resource
    private LogCountServiceImpl logCountService;
    @Value(value="$job_start_flag")
    public String jobStartFlag;

    public void init() {
        if (!Boolean.parseBoolean(this.jobStartFlag)) {
            return;
        }
        ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(ThreadUtil.newNamedThreadFactory((String)"log-tailLogCountJob", (boolean)false));
        long initDelay = 0L;
        long intervalTime = 1L;
        scheduledExecutor.scheduleAtFixedRate(() -> this.statisticsAll(), initDelay, intervalTime, TimeUnit.HOURS);
    }

    public void statisticsAll() {
        try {
            log.info("Statistics log scheduled task starts execution");
            String thisDay = DateUtils.getDaysAgo((int)1);
            if (!this.logCountService.isLogtailCountDone(thisDay)) {
                this.logCountService.collectLogCount(thisDay);
                this.logCountService.deleteHistoryLogCount();
            }
            this.logCountService.collectTopCount();
            this.logCountService.collectSpaceTopCount();
            this.logCountService.collectSpaceTrend();
            log.info("Statistics log scheduled task execution completed");
        }
        catch (Exception e) {
            log.error("Statistical log timing task failed", (Throwable)e);
        }
    }
}

