/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.manager.domain;

import com.xiaomi.youpin.docean.Ioc;
import com.xiaomi.youpin.docean.anno.Service;
import com.xiaomi.youpin.docean.common.StringUtils;
import com.xiaomi.youpin.docean.plugin.es.EsService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.ozhera.log.common.Constant;
import org.apache.ozhera.log.manager.bootstrap.LogStoragePlugin;
import org.apache.ozhera.log.manager.common.context.MoneUserContext;
import org.apache.ozhera.log.manager.mapper.MilogEsClusterMapper;
import org.apache.ozhera.log.manager.model.pojo.MilogEsClusterDO;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionService;
import org.apache.ozhera.log.manager.service.extension.store.StoreExtensionServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service
public class EsCluster {
    private static final Logger log = LoggerFactory.getLogger(EsCluster.class);
    @Resource
    private MilogEsClusterMapper esClusterMapper;
    @Resource
    private LogStoragePlugin logStoragePlugin;
    private StoreExtensionService storeExtensionService;

    public void init() {
        this.storeExtensionService = StoreExtensionServiceFactory.getStoreExtensionService();
    }

    public EsService getEsService(Long esClusterId) {
        if (esClusterId == null) {
            return null;
        }
        String beanName = Constant.LOG_STORAGE_SERV_BEAN_PRE + esClusterId;
        if (this.isBeanInitialized(esClusterId, beanName)) {
            return (EsService)Ioc.ins().getBean(beanName);
        }
        return null;
    }

    private boolean isBeanInitialized(Long esClusterId, String beanName) {
        if (Ioc.ins().containsBean(beanName)) {
            return true;
        }
        this.logStoragePlugin.initializeLogStorage(this.getById(esClusterId));
        return Ioc.ins().containsBean(beanName);
    }

    public EsService getEsService() {
        MilogEsClusterDO curEsCluster = this.getCurEsCluster();
        if (curEsCluster == null) {
            return null;
        }
        if (Ioc.ins().containsBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + curEsCluster.getId())) {
            return (EsService)Ioc.ins().getBean(Constant.LOG_STORAGE_SERV_BEAN_PRE + curEsCluster.getId());
        }
        return null;
    }

    public MilogEsClusterDO getCurEsCluster() {
        List<MilogEsClusterDO> esClusterList = this.esClusterMapper.selectByTag(MoneUserContext.getCurrentUser().getZone());
        MilogEsClusterDO cluster = esClusterList == null || esClusterList.isEmpty() ? null : esClusterList.get(0);
        log.info("[EsCluster.getCurEsCluster] user is {}, cluster is {}", (Object)MoneUserContext.getCurrentUser(), (Object)cluster.getName());
        return cluster;
    }

    public MilogEsClusterDO getById(Long id) {
        return (MilogEsClusterDO)this.esClusterMapper.selectById(id);
    }

    public MilogEsClusterDO getByRegion(String region) {
        if (StringUtils.isEmpty((String)region)) {
            return null;
        }
        MilogEsClusterDO esClusterDO = this.esClusterMapper.selectByRegion(region);
        return esClusterDO;
    }

    public MilogEsClusterDO getByArea4China(String area) {
        if (StringUtils.isEmpty((String)area)) {
            return null;
        }
        List<MilogEsClusterDO> clusterList = this.esClusterMapper.selectByArea(area, this.storeExtensionService.getMangerEsLabel());
        if (clusterList == null || clusterList.isEmpty()) {
            return null;
        }
        if (clusterList.size() > 1) {
            String zone = MoneUserContext.getCurrentUser().getZone();
            for (MilogEsClusterDO clusterDO : clusterList) {
                if (!Objects.equals(zone, clusterDO.getTag())) continue;
                return clusterDO;
            }
        }
        return clusterList.get(0);
    }
}

