/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.webhook.common;

import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private PoolingHttpClientConnectionManager pool = null;
    private int TIMEOUT = 5000;
    private int MAX_HTTP_TOTAL_CONNECTION = 1000;
    private int MAX_CONNECTION_PER_HOST = 200;
    private RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.TIMEOUT).setConnectTimeout(this.TIMEOUT).setConnectionRequestTimeout(this.TIMEOUT).build();
    private CloseableHttpClient singleHttpClient = null;

    private HttpClientUtil() {
        ConnectionKeepAliveStrategy keepAliveStrategy = new ConnectionKeepAliveStrategy(this){

            public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
                return 20000L;
            }
        };
        this.pool = new PoolingHttpClientConnectionManager();
        this.pool.setMaxTotal(this.MAX_HTTP_TOTAL_CONNECTION);
        this.pool.setDefaultMaxPerRoute(this.MAX_CONNECTION_PER_HOST);
        this.singleHttpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.pool).setKeepAliveStrategy(keepAliveStrategy).setMaxConnTotal(this.MAX_HTTP_TOTAL_CONNECTION).setMaxConnPerRoute(this.MAX_CONNECTION_PER_HOST).setDefaultRequestConfig(this.requestConfig).setUserAgent("Mozilla/4.0").build();
    }

    public static HttpClientUtil getInstance() {
        return HttpUtilSingle.instance;
    }

    public CloseableHttpClient getHttpClient() {
        return this.singleHttpClient;
    }

    public static void closeResponse(HttpUriRequest hur, CloseableHttpResponse chr, long startTime) {
        String url = "http://aaaa.com";
        int stateCode = -1;
        long endTime = System.currentTimeMillis();
        long useTime = endTime - startTime;
        try {
            if (null != hur) {
                url = hur.getURI().getPath();
            }
            if (null != chr) {
                stateCode = chr.getStatusLine().getStatusCode();
                chr.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public RequestConfig getRequestConfig() {
        return this.requestConfig;
    }

    public static long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String sendPostRequest(String url, String body, Map<String, String> headers) {
        CloseableHttpClient client = HttpClientUtil.getInstance().getHttpClient();
        try {
            RequestBuilder requestBuilder = RequestBuilder.post((String)url);
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    requestBuilder.setHeader(headerKey, headers.get(headerKey));
                }
            }
            requestBuilder.setConfig(HttpClientUtil.getInstance().getRequestConfig());
            if (StringUtils.isNotEmpty((CharSequence)body)) {
                StringEntity entity = new StringEntity(body, Charset.forName("UTF-8"));
                requestBuilder.setEntity((HttpEntity)entity);
            }
            HttpUriRequest httpUriRequest = requestBuilder.build();
            String responseBody = null;
            try (CloseableHttpResponse response = null;){
                response = client.execute(httpUriRequest);
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"utf-8");
                log.info("response body : " + responseBody);
                String string = responseBody;
                return string;
            }
        }
        catch (Exception e2) {
            log.error("Failed to call post : url : " + url + " body : " + body, (Throwable)e2);
        }
        return null;
    }

    private static class HttpUtilSingle {
        private static HttpClientUtil instance = new HttpClientUtil();

        private HttpUtilSingle() {
        }
    }
}

