/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.controller;

import java.util.List;
import org.apache.ozhera.app.model.vo.HeraAppEnvVo;
import org.apache.ozhera.app.model.vo.HeraAppOperateVo;
import org.apache.ozhera.app.service.HeraAppEnvService;
import org.apache.ozhera.app.valid.AddGroup;
import org.apache.ozhera.app.valid.UpdateGroup;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/hera/app/env"})
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class HeraAppEnvController {
    @Autowired
    private HeraAppEnvService heraAppEnvService;

    @GetMapping(value={"/id"})
    public HeraAppEnvVo queryAppEnvById(@RequestParam(value="id") Long id) {
        return this.heraAppEnvService.queryAppEnvById(id);
    }

    @PostMapping(value={"/add"})
    public Long addAppEnv(@Validated(value={AddGroup.class}) @RequestBody HeraAppOperateVo operateVo) {
        return this.heraAppEnvService.addAppEnv(operateVo);
    }

    @PostMapping(value={"/update"})
    public Long updateAppEnv(@Validated(value={UpdateGroup.class}) @RequestBody HeraAppOperateVo operateVo) {
        return this.heraAppEnvService.updateAppEnv(operateVo);
    }

    @PostMapping(value={"/delete"})
    public Boolean deleteAppEnv(@RequestParam(value="id") Long id) {
        return this.heraAppEnvService.deleteAppEnv(id);
    }

    @GetMapping(value={"/non/probe/ips"})
    public List<String> queryNonProbeAccessIPs() {
        return this.heraAppEnvService.queryNonProbeAccessIPs();
    }
}

