/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.common;

import java.io.Serializable;
import org.apache.ozhera.app.enums.CommonError;
import org.apache.ozhera.app.exception.AppException;

public class Result<T>
implements Serializable {
    private int code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> fail(CommonError error) {
        return new Result<T>(error.getCode(), error.getMessage());
    }

    public boolean isSuccess() {
        return this.getCode() == CommonError.Success.getCode();
    }

    public static <T> Result<T> failParam(String errorMsg) {
        return new Result<T>(CommonError.ParamsError.getCode(), errorMsg);
    }

    public static <T> Result<T> fail(AppException ex) {
        return new Result<T>(ex.getCode(), ex.getMessage());
    }

    public static <T> Result<T> success(T t) {
        return new Result<T>(CommonError.Success.getCode(), CommonError.Success.getMessage(), t);
    }

    public static <T> Result<T> success() {
        return new Result<T>(CommonError.Success.getCode(), CommonError.Success.getMessage());
    }

    public static <T> Result<T> fail(Integer code, String msg) {
        return new Result<T>(code, msg);
    }

    public static Result error(String msg) {
        return new Result(CommonError.SERVER_ERROR.getCode(), msg);
    }

    public static <T> Result error(Integer code, String msg, T data) {
        return new Result<T>(code, msg, data);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }
}

