/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.runtime.dynamic.sql.elements;

import java.util.HashSet;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.Interface;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.codegen.mybatis3.ListUtilities;
import org.mybatis.generator.runtime.dynamic.sql.elements.AbstractMethodGenerator;
import org.mybatis.generator.runtime.dynamic.sql.elements.MethodAndImports;

public class InsertMethodGenerator
extends AbstractMethodGenerator {
    private String tableFieldName;
    private FullyQualifiedJavaType recordType;

    private InsertMethodGenerator(Builder builder) {
        super(builder);
        this.tableFieldName = builder.tableFieldName;
        this.recordType = builder.recordType;
    }

    @Override
    public MethodAndImports generateMethodAndImports() {
        if (!this.introspectedTable.getRules().generateInsert()) {
            return null;
        }
        HashSet<FullyQualifiedJavaType> imports = new HashSet<FullyQualifiedJavaType>();
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.SqlBuilder"));
        imports.add(new FullyQualifiedJavaType("org.mybatis.dynamic.sql.render.RenderingStrategy"));
        imports.add(this.recordType);
        Method method = new Method("insert");
        method.setDefault(true);
        this.context.getCommentGenerator().addGeneralMethodAnnotation(method, this.introspectedTable, imports);
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.addParameter(new Parameter(this.recordType, "record"));
        method.addBodyLine("return insert(SqlBuilder.insert(record)");
        method.addBodyLine("        .into(" + this.tableFieldName + ")");
        List<IntrospectedColumn> columns = ListUtilities.removeIdentityAndGeneratedAlwaysColumns(this.introspectedTable.getAllColumns());
        for (IntrospectedColumn column : columns) {
            method.addBodyLine("        .map(" + column.getJavaProperty() + ").toProperty(\"" + column.getJavaProperty() + "\")");
        }
        method.addBodyLine("        .build()");
        method.addBodyLine("        .render(RenderingStrategy.MYBATIS3));");
        return MethodAndImports.withMethod(method).withImports(imports).build();
    }

    @Override
    public boolean callPlugins(Method method, Interface interfaze) {
        return this.context.getPlugins().clientInsertMethodGenerated(method, interfaze, this.introspectedTable);
    }

    public static class Builder
    extends AbstractMethodGenerator.BaseBuilder<Builder, InsertMethodGenerator> {
        private String tableFieldName;
        private FullyQualifiedJavaType recordType;

        public Builder withTableFieldName(String tableFieldName) {
            this.tableFieldName = tableFieldName;
            return this;
        }

        public Builder withRecordType(FullyQualifiedJavaType recordType) {
            this.recordType = recordType;
            return this;
        }

        @Override
        public Builder getThis() {
            return this;
        }

        @Override
        public InsertMethodGenerator build() {
            return new InsertMethodGenerator(this);
        }
    }
}

