/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.config;

import java.util.List;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.config.IgnoredColumn;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;

public class IgnoredColumnException
extends IgnoredColumn {
    public IgnoredColumnException(String columnName) {
        super(columnName);
    }

    @Override
    public XmlElement toXmlElement() {
        XmlElement xmlElement = new XmlElement("except");
        xmlElement.addAttribute(new Attribute("column", this.columnName));
        if (StringUtility.stringHasValue(this.configuredDelimitedColumnName)) {
            xmlElement.addAttribute(new Attribute("delimitedColumnName", this.configuredDelimitedColumnName));
        }
        return xmlElement;
    }

    @Override
    public void validate(List<String> errors, String tableName) {
        if (!StringUtility.stringHasValue(this.columnName)) {
            errors.add(Messages.getString("ValidationError.26", tableName));
        }
    }
}

