/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.log.common;

import org.apache.ozhera.log.exception.CommonError;
import org.apache.ozhera.log.exception.CommonException;

public class Result<T> {
    private int code;
    private String message;
    private T data;

    public Result() {
    }

    public Result(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public Result(int code, String message, T data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public static <T> Result<T> fail(CommonError error) {
        return new Result<T>(error.getCode(), error.getMessage());
    }

    public static <T> Result<T> failParam(String errorMsg) {
        return new Result<T>(CommonError.ParamsError.getCode(), errorMsg);
    }

    public static <T> Result<T> fail(CommonException ex) {
        return new Result<T>(ex.getCode(), ex.getMessage());
    }

    public static <T> Result<T> success(T t) {
        return new Result<T>(CommonError.Success.getCode(), CommonError.Success.getMessage(), t);
    }

    public static <T> Result<T> success() {
        return new Result<T>(CommonError.Success.getCode(), CommonError.Success.getMessage());
    }

    public static <T> Result<T> fail(Integer code, String msg) {
        return new Result<T>(code, msg);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return "Result{code=" + this.code + ", message='" + this.message + "', data=" + String.valueOf(this.data) + "}";
    }
}

