/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.data.push.rpc;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xiaomi.data.push.bo.User;
import com.xiaomi.data.push.common.SafeRun;
import com.xiaomi.data.push.common.Service;
import com.xiaomi.data.push.context.AgentContext;
import com.xiaomi.data.push.nacos.NacosNaming;
import com.xiaomi.data.push.rpc.PushChannelEventListener;
import com.xiaomi.data.push.rpc.RpcException;
import com.xiaomi.data.push.rpc.RpcVersion;
import com.xiaomi.data.push.rpc.common.InvokeCallback;
import com.xiaomi.data.push.rpc.common.Pair;
import com.xiaomi.data.push.rpc.common.RemotingUtil;
import com.xiaomi.data.push.rpc.common.RpcServerVersion;
import com.xiaomi.data.push.rpc.netty.AgentChannel;
import com.xiaomi.data.push.rpc.netty.NettyRemotingServer;
import com.xiaomi.data.push.rpc.netty.NettyRequestProcessor;
import com.xiaomi.data.push.rpc.netty.NettyServerConfig;
import com.xiaomi.data.push.rpc.protocol.RemotingCommand;
import com.xiaomi.data.push.task.Task;
import io.netty.channel.Channel;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcServer
implements Service {
    private static final Logger logger = LoggerFactory.getLogger(RpcServer.class);
    private final String name;
    private final String nacosAddrs;
    private NettyRemotingServer server;
    private PushChannelEventListener listener = new PushChannelEventListener();
    private ExecutorService defaultPool;
    private List<Task> tasks = Lists.newArrayList();
    private List<Pair<Integer, NettyRequestProcessor>> processorList = Lists.newArrayList();
    private ScheduledExecutorService pool;
    private List<NacosNaming> nacosNamingList = new ArrayList<NacosNaming>();
    private int listenPort;
    private boolean regNacos = true;

    public RpcServer(String nacosAddrs, String name) {
        this(nacosAddrs, name, true);
    }

    public RpcServer(String nacosAddrs, String name, boolean regNacos) {
        logger.info("rpc server version:{}", (Object)new RpcVersion());
        this.nacosAddrs = nacosAddrs;
        this.name = name;
        this.regNacos = regNacos;
        this.defaultPool = this.creatThreadPool(200);
        if (regNacos) {
            String[] ss = this.nacosAddrs.split("\\$");
            Arrays.stream(ss).forEach(it -> {
                NacosNaming nacosNaming = new NacosNaming();
                nacosNaming.setServerAddr(it);
                nacosNaming.init();
                this.nacosNamingList.add(nacosNaming);
            });
        }
    }

    private ThreadPoolExecutor creatThreadPool(int size) {
        return new ThreadPoolExecutor(size, size, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1000));
    }

    @Override
    @PostConstruct
    public void init() {
        int size = this.tasks.size();
        if (size > 0) {
            this.pool = Executors.newScheduledThreadPool(size);
            this.tasks.forEach(task -> this.pool.scheduleWithFixedDelay(() -> {
                try {
                    logger.info("rpc server client num:{}", (Object)this.listener.clientNum());
                    task.getRunnable().run();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }, 5L, task.getDelay(), TimeUnit.SECONDS));
        }
    }

    public void start(Consumer<NettyServerConfig> consumer) {
        logger.info("rpc server start version:{}", (Object)new RpcServerVersion());
        NettyServerConfig config = new NettyServerConfig();
        if (this.listenPort != 0) {
            config.setListenPort(this.listenPort);
        }
        consumer.accept(config);
        this.server = new NettyRemotingServer(config, this.listener);
        this.processorList.stream().forEach(it -> {
            ExecutorService p = this.defaultPool;
            if (((NettyRequestProcessor)it.getObject2()).poolSize() > 0) {
                p = this.creatThreadPool(((NettyRequestProcessor)it.getObject2()).poolSize());
            }
            this.server.registerProcessor((Integer)it.getObject1(), (NettyRequestProcessor)it.getObject2(), p);
        });
        this.server.start();
        if (this.regNacos) {
            this.regNacos();
        }
    }

    @Override
    public void start() {
        this.start(config -> {});
    }

    private void regNacos() {
        logger.info("reg service to nacos");
        new Thread(() -> Stream.generate(() -> true).limit(1L).forEach(it -> SafeRun.run(() -> this.registerInstance(), "reg service", 2000L))).start();
    }

    public boolean registerInstance() {
        logger.info("registerInstance");
        this.nacosNamingList.stream().forEach(nacosNaming -> {
            try {
                Instance instance = new Instance();
                instance.setEnabled(true);
                instance.setHealthy(true);
                instance.setIp(this.server.getRegHost());
                instance.setPort(this.server.getPort());
                instance.setServiceName(this.name);
                HashMap metaData = Maps.newHashMap();
                metaData.put("ctime", new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").format(new Date()));
                metaData.put("version", new RpcServerVersion().toString());
                SafeRun.run(() -> metaData.put("hostname", InetAddress.getLocalHost().getHostName()));
                instance.setMetadata((Map)metaData);
                nacosNaming.registerInstance(this.name, instance);
                logger.info("reg service {} {}:{} success", new Object[]{this.name, this.server.getHost(), this.server.getPort()});
            }
            catch (Throwable e) {
                logger.warn("registerInstance:{} error:{}", (Object)this.name, (Object)e.getMessage());
            }
        });
        return true;
    }

    public void sendMessageToAll(RemotingCommand remotingCommand, InvokeCallback callback) {
        this.listener.sendMessageToAll(this.server, remotingCommand, 1000L, callback);
    }

    public RemotingCommand sendMessage(Channel channel, RemotingCommand req) {
        return this.sendMessage(channel, req, 1000L);
    }

    public void tell(Predicate<User> predicate, RemotingCommand req) {
        Channel ch = this.listener.channel(predicate);
        Optional.ofNullable(ch).ifPresent(c -> {
            try {
                this.server.invokeOneway(ch, req, 1000L);
            }
            catch (Throwable ex) {
                logger.error(ex.getMessage());
            }
        });
    }

    public void tell(Channel ch, RemotingCommand req) {
        try {
            this.server.invokeOneway(ch, req, 1000L);
        }
        catch (Throwable ex) {
            logger.error(ex.getMessage());
        }
    }

    public RemotingCommand sendMessage(Channel channel, RemotingCommand req, long timeOut) {
        try {
            return this.server.invokeSync(channel, req, timeOut);
        }
        catch (Throwable e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public RemotingCommand sendMessage(String address, RemotingCommand req, long timeOut) {
        Channel channel = this.server.getChannelEventListener().channel(address);
        if (null == channel) {
            logger.warn("channel is null address:{}", (Object)address);
            return null;
        }
        try {
            return this.server.invokeSync(channel, req, timeOut);
        }
        catch (Throwable e) {
            throw new RpcException(e.getMessage(), e);
        }
    }

    public void send(String address, RemotingCommand req, long timeout, InvokeCallback callback) {
        Channel channel = this.server.getChannelEventListener().channel(address);
        if (null != channel) {
            try {
                this.server.invokeAsync(channel, req, timeout, callback);
            }
            catch (Throwable e) {
                throw new RpcException(e.getMessage(), e);
            }
        }
    }

    public void send(Consumer<Channel> consumer) {
        this.listener.send(consumer);
    }

    public int clientNum() {
        return this.listener.clientNum();
    }

    public ArrayList<Channel> clients() {
        return new ArrayList<Channel>(this.listener.clients());
    }

    @Override
    public void shutdown() {
        logger.info("rpcserver:{} shutdown", (Object)this.name);
        this.deregisterInstance();
        if (null != this.pool) {
            this.pool.shutdown();
        }
        if (null != this.server) {
            this.server.shutdown();
        }
    }

    public void deregisterInstance() {
        this.nacosNamingList.stream().forEach(nacosNaming -> {
            try {
                nacosNaming.deregisterInstance(this.name, this.server.getHost(), this.server.getPort());
            }
            catch (NacosException e) {
                logger.warn("nacos dergister error:{}", (Object)e.getMessage());
            }
        });
    }

    public NettyRemotingServer getServer() {
        return this.server;
    }

    public List<String> clientList() {
        return this.listener.clients().stream().map(it -> {
            Channel c = it;
            if (c.remoteAddress() instanceof InetSocketAddress) {
                InetSocketAddress ia = (InetSocketAddress)it.remoteAddress();
                return String.valueOf(ia.getAddress()) + ":" + ia.getPort();
            }
            return it.remoteAddress().toString();
        }).collect(Collectors.toList());
    }

    public void closeClient(String address) {
        logger.info("close client:{}", (Object)address);
        AgentChannel ch = AgentContext.ins().map.remove(address);
        if (null != ch) {
            RemotingUtil.closeChannel(ch.getChannel());
        }
    }

    @Override
    public RemotingCommand call(RemotingCommand req) {
        return this.sendMessage(req.getAddress(), req, req.getTimeout());
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public void setProcessorList(List<Pair<Integer, NettyRequestProcessor>> processorList) {
        this.processorList = processorList;
    }

    public void setListenPort(int listenPort) {
        this.listenPort = listenPort;
    }
}

