/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.file.ozhera;

import com.google.common.collect.Lists;
import com.xiaomi.mone.file.common.FileInfo;
import com.xiaomi.mone.file.common.FileInfoCache;
import com.xiaomi.mone.file.common.FileUtils;
import com.xiaomi.mone.file.common.Pair;
import com.xiaomi.mone.file.event.EventListener;
import com.xiaomi.mone.file.event.EventType;
import com.xiaomi.mone.file.event.FileEvent;
import com.xiaomi.mone.file.ozhera.HeraFile;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeraFileMonitor {
    private static final Logger log = LoggerFactory.getLogger(HeraFileMonitor.class);
    private ConcurrentHashMap<Object, HeraFile> map = new ConcurrentHashMap();
    private ConcurrentHashMap<String, HeraFile> fileMap = new ConcurrentHashMap();
    private EventListener listener;
    private volatile boolean stop;
    private ReentrantLock lock = new ReentrantLock();

    public HeraFileMonitor() {
        this(TimeUnit.SECONDS.toMillis(30L));
    }

    public HeraFileMonitor(long removeTime) {
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            try {
                ArrayList remList = Lists.newArrayList();
                long now = System.currentTimeMillis();
                this.fileMap.values().forEach(it -> {
                    if (now - it.getUtime().get() >= removeTime && now - it.getReadTime().get() >= removeTime) {
                        remList.add(Pair.of(it.getFileName(), it.getFileKey()));
                    }
                });
                remList.forEach(it -> {
                    log.info("remove file:{},fileKey:{}", it.getKey(), it.getValue());
                    this.fileMap.remove(it.getKey());
                    this.map.remove(it.getValue());
                    this.listener.remove(it.getValue());
                });
            }
            catch (Throwable ex) {
                log.error("remove file error", ex);
            }
        }, 5L, 10L, TimeUnit.SECONDS);
    }

    public HeraFileMonitor(EventListener listener) {
        this();
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reg(String path, Predicate<String> predicate) throws IOException, InterruptedException {
        Path directory = Paths.get(path, new String[0]);
        File f = directory.toFile();
        if (!f.exists()) {
            log.info("create directory:{}", (Object)directory);
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        Arrays.stream(Objects.requireNonNull(f.listFiles())).filter(it -> predicate.test(it.getPath())).forEach(this::initFile);
        WatchService watchService = FileSystems.getDefault().newWatchService();
        directory.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_CREATE);
        while (!this.stop) {
            try {
                WatchKey key = watchService.take();
                try {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path modifiedFile = (Path)event.context();
                        String filePath = String.format("%s%s", path, modifiedFile.getFileName().toString());
                        if (!predicate.test(filePath) || modifiedFile.getFileName().toString().startsWith(".")) continue;
                        HeraFile hfile = this.fileMap.get(filePath);
                        if (event.kind() == StandardWatchEventKinds.ENTRY_MODIFY) {
                            if (null == hfile) {
                                hfile = this.initFile(new File(filePath));
                            }
                            this.modify(hfile);
                        }
                        if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                            this.fileMap.remove(filePath);
                            if (null != hfile) {
                                this.map.remove(hfile.getFileKey());
                                this.listener.onEvent(FileEvent.builder().type(EventType.delete).fileName(filePath).fileKey(hfile.getFileKey()).build());
                            }
                        }
                        if (event.kind() != StandardWatchEventKinds.ENTRY_CREATE) continue;
                        File file = new File(filePath);
                        Object k = FileUtils.fileKey(file);
                        if (this.map.containsKey(k)) {
                            log.info("change name " + String.valueOf(this.map.get(k)) + "--->" + String.valueOf(file));
                            this.listener.onEvent(FileEvent.builder().fileKey(k).type(EventType.rename).build());
                            continue;
                        }
                        log.info("ENTRY_CREATE filePath:{},fileKey:{}", (Object)filePath, k);
                        HeraFile hf = HeraFile.builder().file(file).fileKey(k).fileName(filePath).build();
                        this.map.putIfAbsent(k, hf);
                        this.fileMap.put(filePath, hf);
                        this.listener.onEvent(FileEvent.builder().type(EventType.create).fileKey(k).fileName(file.getPath()).build());
                    }
                }
                catch (Exception e1) {
                    log.error("watchService poll events error", (Throwable)e1);
                }
                finally {
                    key.reset();
                }
            }
            catch (Exception e) {
                log.error("watchService error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HeraFile initFile(File it) {
        if (it.isFile()) {
            String name = it.getName();
            if (name.startsWith(".")) {
                return null;
            }
            this.lock.lock();
            try {
                Object fileKey = FileUtils.fileKey(it);
                if (this.map.containsKey(fileKey)) {
                    HeraFile heraFile = this.map.get(fileKey);
                    return heraFile;
                }
                HeraFile hf = HeraFile.builder().file(it).fileKey(fileKey).fileName(it.getPath()).build();
                FileInfo fi = FileInfoCache.ins().get(fileKey.toString());
                long pointer = 0L;
                if (null != fi) {
                    pointer = fi.getPointer();
                }
                log.info("initFile fileName:{},fileKey:{}", (Object)name, fileKey);
                this.map.put(hf.getFileKey(), hf);
                this.fileMap.put(hf.getFileName(), hf);
                log.info("initFile hf:{},map size:{},fileMap size:{}", new Object[]{hf, this.map.size(), this.fileMap.size()});
                this.listener.onEvent(FileEvent.builder().pointer(pointer).type(EventType.init).fileName(hf.getFileName()).fileKey(hf.getFileKey()).build());
                HeraFile heraFile = hf;
                return heraFile;
            }
            catch (Exception e) {
                log.error("init file error,fileName:{}", (Object)name, (Object)e);
            }
            finally {
                this.lock.unlock();
            }
        }
        return null;
    }

    private void modify(HeraFile hfile) {
        if (null != hfile) {
            hfile.getUtime().set(System.currentTimeMillis());
            if (hfile.getFile().length() == 0L) {
                this.listener.onEvent(FileEvent.builder().type(EventType.empty).fileName(hfile.getFileName()).fileKey(hfile.getFileKey()).build());
            } else {
                this.listener.onEvent(FileEvent.builder().type(EventType.modify).build());
            }
        }
    }

    public void stop() {
        this.stop = true;
        this.listener.stop();
    }

    public ConcurrentHashMap<Object, HeraFile> getMap() {
        return this.map;
    }

    public ConcurrentHashMap<String, HeraFile> getFileMap() {
        return this.fileMap;
    }

    public void setListener(EventListener listener) {
        this.listener = listener;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

