/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.spring;

import javax.servlet.ServletContext;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.lang.util.AbstractLifeCycle;
import org.nutz.mvc.Mvcs;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.ContextLoaderListener;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringIocLoader
extends AbstractLifeCycle
implements IocLoader {
    protected ApplicationContext context;
    protected ContextLoaderListener ctx;
    protected boolean inited;
    protected String contextConfigLocation;

    public SpringIocLoader() {
    }

    public SpringIocLoader(String contextConfigLocation) {
        this.contextConfigLocation = contextConfigLocation;
        ServletContext sc = Mvcs.getServletContext();
        if (sc != null && sc.getInitParameter("contextConfigLocation") == null) {
            sc.setInitParameter("contextConfigLocation", contextConfigLocation);
        }
    }

    public String[] getName() {
        return this.context().getBeanDefinitionNames();
    }

    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        if (!this.has(name)) {
            throw new IocException(name, "not such bean in spring ioc", new Object[0]);
        }
        IocObject iocObject = new IocObject();
        iocObject.addArg(new IocValue("normal", (Object)this.context()));
        iocObject.addArg(new IocValue("normal", (Object)name));
        iocObject.setFactory("org.nutz.integration.spring.SpringIocLoader#fromSpring");
        iocObject.setType(this.context().getType(name));
        return iocObject;
    }

    public boolean has(String name) {
        return this.context().containsBean(name);
    }

    protected ApplicationContext context() {
        if (this.context == null) {
            this._init();
        }
        return this.context;
    }

    public static Object fromSpring(ApplicationContext context, String name) {
        return context.getBean(name);
    }

    public void _init() {
        if (this.context == null) {
            if (this.contextConfigLocation == null) {
                this.context = WebApplicationContextUtils.getRequiredWebApplicationContext((ServletContext)Mvcs.getServletContext());
            } else {
                this.ctx = new ContextLoaderListener();
                ServletContext sc = Mvcs.getServletContext();
                this.context = this.ctx.initWebApplicationContext(sc);
            }
        }
    }

    public void depose() throws Exception {
        if (this.ctx != null) {
            this.ctx.closeWebApplicationContext(Mvcs.getServletContext());
        }
    }
}

