/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.app.service.env;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Resource;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ozhera.app.common.Constant;
import org.apache.ozhera.app.common.Result;
import org.apache.ozhera.app.model.vo.TpcLabelRes;
import org.apache.ozhera.app.model.vo.TpcPageRes;
import org.apache.ozhera.app.service.env.DefaultHttpEnvIpFetch;
import org.apache.ozhera.app.service.env.DefaultNacosEnvIpFetch;
import org.apache.ozhera.app.service.env.EnvIpFetch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"service.selector.property"}, havingValue="outer")
public class DefaultEnvIpFetch {
    private static final Logger log = LoggerFactory.getLogger(DefaultEnvIpFetch.class);
    @Autowired
    private DefaultHttpEnvIpFetch defaultHttpEnvIpFetch;
    @Autowired
    private DefaultNacosEnvIpFetch defaultNacosEnvIpFetch;
    @Value(value="${app.ip.fetch.type}")
    private String envAppType;
    @NacosValue(value="${hera.tpc.url}", autoRefreshed=true)
    private String heraTpcUrl;
    @NacosValue(value="${hera.tpc.token}", autoRefreshed=true)
    private String heraTpcToken;
    @Resource
    private OkHttpClient okHttpClient;
    @Autowired
    private Gson gson;

    public EnvIpFetch getEnvIpFetch() {
        if (Objects.equals(EnvIpTypeEnum.HTTP.name().toLowerCase(), this.envAppType)) {
            return this.defaultHttpEnvIpFetch;
        }
        return this.defaultNacosEnvIpFetch;
    }

    public EnvIpFetch getEnvFetch(String appId) {
        EnvIpFetch fetchFromRemote = this.getEnvFetchFromRemote(appId);
        if (null != fetchFromRemote) {
            return fetchFromRemote;
        }
        return this.getEnvIpFetch();
    }

    public EnvIpFetch getEnvFetchFromRemote(String appId) {
        JsonObject jsonObject = new JsonObject();
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        jsonObject.addProperty("parentId", appId);
        jsonObject.addProperty("flagKey", Constant.DEFAULT_REGISTER_REMOTE_TYPE);
        jsonObject.addProperty("token", this.heraTpcToken);
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)this.gson.toJson((JsonElement)jsonObject));
        Request request = new Request.Builder().url(String.format("%s%s", this.heraTpcUrl, Constant.URL.HERA_TPC_APP_DETAIL_URL)).post(requestBody).build();
        try {
            Response response = this.okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String rstJson = response.body().string();
                log.info("getEnvFetchFromRemote,appId:{},result:{}", (Object)appId, (Object)rstJson);
                Result pageResponseResult = (Result)this.gson.fromJson(rstJson, new TypeToken<Result<TpcPageRes<TpcLabelRes>>>(this){}.getType());
                if (null != pageResponseResult && null != pageResponseResult.getData() && CollectionUtils.isNotEmpty((Collection)((TpcPageRes)pageResponseResult.getData()).getList())) {
                    for (TpcLabelRes tpcLabelRes : ((TpcPageRes)pageResponseResult.getData()).getList()) {
                        if (!Objects.equals(Boolean.TRUE.toString(), tpcLabelRes.getFlagVal())) continue;
                        return this.defaultHttpEnvIpFetch;
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("getEnvFetchFromRemote error,appId:{}", (Object)appId, (Object)e);
        }
        return null;
    }

    public static enum EnvIpTypeEnum {
        NACOS,
        HTTP;

    }
}

