/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mone.tpc.common.vo;

import com.xiaomi.mone.tpc.common.vo.ResultVo;
import org.apache.commons.lang3.StringUtils;

public enum ResponseCode {
    SUCCESS(0, "\u6210\u529f"),
    UNKNOWN_ERROR(99, "\u672a\u77e5\u9519\u8bef"),
    ARG_ERROR(101, "\u53c2\u6570\u9519\u8bef"),
    USER_DISABLED(102, "\u60a8\u5df2\u88ab\u7981\u7528"),
    NO_OPER_PERMISSION(104, "\u6ca1\u6709\u64cd\u4f5c\u6743\u9650"),
    OPER_FAIL(105, "\u64cd\u4f5c\u5931\u8d25"),
    OPER_ILLEGAL(106, "\u975e\u6cd5\u64cd\u4f5c"),
    NO_USER_ACCOUNT(107, "\u8bf7\u6c42\u5934\u6ca1\u6709user"),
    OUTER_CALL_FAILED(108, "\u5916\u90e8\u8bf7\u6c42\u5931\u8d25"),
    CHECK_FAILED(109, "\u68c0\u67e5\u5931\u8d25");

    private int code;
    private String message;

    private ResponseCode(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public <T> ResultVo<T> build(T data) {
        return this.build(null, data);
    }

    public <T> ResultVo<T> build(String desc) {
        return this.build(desc, null);
    }

    public <T> ResultVo<T> build() {
        return this.build(null, null);
    }

    public <T> ResultVo<T> build(String desc, T data) {
        ResultVo<T> result = new ResultVo<T>();
        result.setData(data);
        result.setCode(this.code);
        if (StringUtils.isNotBlank((CharSequence)desc)) {
            result.setMessage(desc);
        } else {
            result.setMessage(this.message);
        }
        return result;
    }

    public String toString() {
        return "ResponseCode." + this.name() + "(code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }
}

