/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.lang;

import java.awt.GraphicsEnvironment;

public abstract class OS {
    public static final String OS_NAME = OS.sysProp("os.name").toLowerCase();
    public static final String JAVA_SPECIFICATION_VERSION = OS.sysProp("java.specification.version");
    public static final String JAVA_VERSION = OS.sysProp("java.version");
    private static String[] _fonts;
    public static boolean isJava1_1;
    public static boolean isJava1_2;
    public static boolean isJava1_3;
    public static boolean isJava1_4;
    public static boolean isJava1_5;
    public static boolean isJava1_6;
    public static boolean isJava1_7;
    public static boolean isJava1_8;
    public static boolean isJava1_9;

    private static String sysProp(String property) {
        try {
            return System.getProperty(property);
        }
        catch (SecurityException ex) {
            System.err.println("SecurityException on try find system property '" + property + "'");
            return "";
        }
    }

    private static void refreshFonts() {
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        _fonts = environment.getAvailableFontFamilyNames();
    }

    public static String[] fonts() {
        return (String[])_fonts.clone();
    }

    public static String[] fontsRefresh() {
        OS.refreshFonts();
        return OS.fonts();
    }

    public static boolean isLinux() {
        return OS_NAME.indexOf("linux") >= 0;
    }

    public static boolean isMacOS() {
        return OS_NAME.indexOf("mac") >= 0;
    }

    public static boolean isWindows() {
        return OS_NAME.indexOf("windows") >= 0;
    }

    public static boolean isAndroid() {
        try {
            Class.forName("android.Manifest");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static boolean isJavaVersion(String versionPrefix) {
        return JAVA_SPECIFICATION_VERSION.startsWith(versionPrefix);
    }

    static {
        OS.refreshFonts();
        isJava1_1 = OS.isJavaVersion("1.1");
        isJava1_2 = OS.isJavaVersion("1.2");
        isJava1_3 = OS.isJavaVersion("1.3");
        isJava1_4 = OS.isJavaVersion("1.4");
        isJava1_5 = OS.isJavaVersion("1.5");
        isJava1_6 = OS.isJavaVersion("1.6");
        isJava1_7 = OS.isJavaVersion("1.7");
        isJava1_8 = OS.isJavaVersion("1.8");
        isJava1_9 = OS.isJavaVersion("9");
    }
}

