/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.youpin.docean.mvc.util;

import com.google.gson.JsonObject;
import com.xiaomi.youpin.docean.config.HttpServerConfig;
import com.xiaomi.youpin.docean.mvc.HttpRequestUtils;
import com.xiaomi.youpin.docean.mvc.upload.Upload;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class RequestUtils {
    public static byte[] getData(HttpServerConfig config, String uri, FullHttpRequest request) {
        return RequestUtils.getData(config, uri, request, null);
    }

    public static byte[] getData(HttpServerConfig config, String uri, FullHttpRequest request, Consumer consumer) {
        if (Upload.isUpload(uri)) {
            if (config.isUpload()) {
                QueryStringDecoder decoder = new QueryStringDecoder(request.uri());
                Map<String, String> params = decoder.parameters().entrySet().stream().collect(Collectors.toMap(it -> (String)it.getKey(), it -> (String)((List)it.getValue()).get(0)));
                consumer.accept(params);
                String fileName = Upload.upload(config.getUploadDir(), (HttpRequest)request);
                return fileName.getBytes();
            }
            throw new RuntimeException("don't support upload file");
        }
        if (request.method().equals((Object)HttpMethod.GET)) {
            return new byte[0];
        }
        if (request.method().equals((Object)HttpMethod.POST)) {
            return HttpRequestUtils.getRequestBody(request);
        }
        return new byte[0];
    }

    public static Map<String, String> headers(FullHttpRequest request) {
        return request.headers().entries().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e, n) -> n));
    }

    public static JsonObject createSessionJsonObject(String name) {
        JsonObject obj = new JsonObject();
        obj.addProperty("__type__", "session");
        obj.addProperty("__name__", name);
        return obj;
    }
}

