/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.rocketmq;

import com.alibaba.fastjson.JSON;
import org.apache.ozhera.monitor.service.rocketmq.model.HeraAppMessage;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.common.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class RocketMqProducer {
    private static final Logger log = LoggerFactory.getLogger(RocketMqProducer.class);
    @Value(value="${rocketmq.topic.hera.app}")
    private String heraAppTopic;
    @Value(value="${rocketmq.tag.hera.app}")
    private String heraAppTag;
    @Autowired
    @Qualifier(value="defaultMQProducer")
    private DefaultMQProducer producer;

    public void pushHeraAppMsg(HeraAppMessage heraAppMessage) {
        Message msg = new Message(this.heraAppTopic, this.heraAppTag, JSON.toJSONString((Object)heraAppMessage).getBytes());
        try {
            this.producer.send(msg);
            log.info("pushHeraAppMsg send rocketmq message : {}", (Object)heraAppMessage.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("pushHeraAppMsg error: " + e.getMessage(), (Throwable)e);
        }
    }
}

