/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.dao.AppServiceMarketDao;
import org.apache.ozhera.monitor.dao.model.AppServiceMarket;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.ServiceMarketService;
import org.apache.ozhera.monitor.service.api.ServiceMarketExtension;
import org.apache.ozhera.monitor.service.extension.PlatFormTypeExtensionService;
import org.apache.ozhera.monitor.service.model.PageData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ServiceMarketServiceImpl
implements ServiceMarketService {
    private static final Logger log = LoggerFactory.getLogger(ServiceMarketServiceImpl.class);
    @Autowired
    AppServiceMarketDao appServiceMarketDao;
    @Value(value="${server.type}")
    private String env;
    @NacosValue(value="${grafana.domain}", autoRefreshed=true)
    private String grafanaDomain;
    @Autowired
    ServiceMarketExtension serviceMarketExtension;
    @Autowired
    PlatFormTypeExtensionService platFormTypeExtensionService;

    @Override
    public Result createMarket(String user, String marketName, String belongTeam, String serviceList, String remark, Integer serviceType) {
        serviceType = this.platFormTypeExtensionService.getMarketType(serviceType);
        try {
            String[] services = serviceList.split(";");
            AppServiceMarket appServiceMarket = new AppServiceMarket();
            appServiceMarket.setMarketName(marketName.trim());
            appServiceMarket.setServiceList(serviceList.trim());
            appServiceMarket.setCreator(user);
            appServiceMarket.setLastUpdater(user);
            appServiceMarket.setRemark(remark.trim());
            appServiceMarket.setBelongTeam(belongTeam.trim());
            appServiceMarket.setServiceType(serviceType);
            int dbResult = this.appServiceMarketDao.insertServiceMarket(appServiceMarket);
            log.info("ServiceMarketService.createMarket dbResult: {}", (Object)dbResult);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("ServiceMarketService.createMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result searchMarket(String user, int id) {
        try {
            AppServiceMarket appServiceMarket = this.appServiceMarketDao.SearchAppServiceMarket(id);
            return Result.success((Object)appServiceMarket);
        }
        catch (Exception e) {
            log.error("ServiceMarketService.searchMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public String getServiceMarketGrafana(Integer serviceType) {
        return this.serviceMarketExtension.getServiceMarketGrafana(serviceType);
    }

    @Override
    public Result searchMarketList(String user, int pageSize, int pageNo, String creator, String marketName, String serviceName) {
        AppServiceMarket appServiceMarket = new AppServiceMarket();
        if (StringUtils.isNotEmpty((CharSequence)creator)) {
            appServiceMarket.setCreator(creator);
        }
        PageData<List<AppServiceMarket>> pd = new PageData<List<AppServiceMarket>>();
        pd.setPage(pageNo);
        pd.setPageSize(pageSize);
        pd.setTotal(this.appServiceMarketDao.getTotal(creator, marketName, serviceName));
        pd.setList(this.appServiceMarketDao.SearchAppServiceMarketList(pageNo, pageSize, creator, marketName, serviceName));
        return Result.success(pd);
    }

    @Override
    public Result updateMarket(String user, int id, String serviceList, String marketName, String remark, String belongTeam, int serviceType) {
        serviceType = this.platFormTypeExtensionService.getMarketType(serviceType);
        try {
            AppServiceMarket appServiceMarket = this.appServiceMarketDao.SearchAppServiceMarket(id);
            if (appServiceMarket == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentServiceMarketId);
            }
            appServiceMarket.setMarketName(marketName.trim());
            appServiceMarket.setServiceList(serviceList.trim());
            appServiceMarket.setLastUpdater(user);
            appServiceMarket.setRemark(remark.trim());
            appServiceMarket.setBelongTeam(belongTeam.trim());
            appServiceMarket.setServiceType(serviceType);
            int dbResult = this.appServiceMarketDao.updateServiceMarket(appServiceMarket);
            log.info("ServiceMarketService.updateMarket dbResult: {}", (Object)dbResult);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("ServiceMarketService.updateMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }

    @Override
    public Result deleteMarket(String user, Integer id) {
        try {
            AppServiceMarket appServiceMarket = this.appServiceMarketDao.SearchAppServiceMarket(id);
            if (appServiceMarket == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentServiceMarketId);
            }
            int result = this.appServiceMarketDao.deleteServiceMarket(id);
            log.info("ServiceMarketService.deleteMarket dbResult:{}", (Object)result);
            return Result.success((Object)"success");
        }
        catch (Exception e) {
            log.error("ServiceMarketService.deleteMarket error : {}", (Object)e.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
    }
}

