/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ozhera.monitor.service.impl;

import com.alibaba.nacos.api.config.annotation.NacosValue;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.ozhera.monitor.bo.AlarmCheckDataCount;
import org.apache.ozhera.monitor.bo.AlarmRuleMetricType;
import org.apache.ozhera.monitor.bo.AlarmRuleTemplateType;
import org.apache.ozhera.monitor.bo.AlarmRuleType;
import org.apache.ozhera.monitor.bo.AlarmSendInterval;
import org.apache.ozhera.monitor.bo.AlarmStrategyType;
import org.apache.ozhera.monitor.bo.AppViewType;
import org.apache.ozhera.monitor.bo.RuleStatusType;
import org.apache.ozhera.monitor.dao.AppAlarmRuleDao;
import org.apache.ozhera.monitor.dao.AppAlarmRuleTemplateDao;
import org.apache.ozhera.monitor.dao.AppMonitorDao;
import org.apache.ozhera.monitor.dao.model.AlarmStrategy;
import org.apache.ozhera.monitor.dao.model.AppAlarmRule;
import org.apache.ozhera.monitor.dao.model.AppAlarmRuleTemplate;
import org.apache.ozhera.monitor.dao.model.AppMonitor;
import org.apache.ozhera.monitor.result.ErrorCode;
import org.apache.ozhera.monitor.result.Result;
import org.apache.ozhera.monitor.service.AlarmStrategyService;
import org.apache.ozhera.monitor.service.AppAlarmService;
import org.apache.ozhera.monitor.service.AppMonitorService;
import org.apache.ozhera.monitor.service.aop.context.HeraRequestMappingContext;
import org.apache.ozhera.monitor.service.api.AlarmPresetMetricsService;
import org.apache.ozhera.monitor.service.api.AppAlarmServiceExtension;
import org.apache.ozhera.monitor.service.model.PageData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleData;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleRequest;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmRuleTemplateRequest;
import org.apache.ozhera.monitor.service.model.prometheus.AlarmTemplateResponse;
import org.apache.ozhera.monitor.service.model.prometheus.AppAlarmRuleTemplateQuery;
import org.apache.ozhera.monitor.service.model.prometheus.AppWithAlarmRules;
import org.apache.ozhera.monitor.service.model.prometheus.ProjectAlarmInfo;
import org.apache.ozhera.monitor.service.prometheus.AlarmService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AppAlarmServiceImpl
implements AppAlarmService {
    private static final Logger log = LoggerFactory.getLogger(AppAlarmServiceImpl.class);
    @Autowired
    AppAlarmRuleDao appAlarmRuleDao;
    @Autowired
    AppAlarmRuleTemplateDao appAlarmRuleTemplateDao;
    @Autowired
    AppMonitorService appMonitorService;
    @Autowired
    AlarmService alarmService;
    @Autowired
    private AppMonitorDao appMonitorDao;
    @Autowired
    private AlarmStrategyService alarmStrategyService;
    @Autowired
    private AlarmPresetMetricsService alarmPresetMetricsService;
    @Autowired
    private AppAlarmServiceExtension appAlarmServiceExtension;
    @NacosValue(value="${rule.evaluation.interval:20}")
    private Integer evaluationInterval;
    @NacosValue(value="${rule.evaluation.unit:s}")
    private String evaluationUnit;
    @Value(value="${prometheus.alarm.env:staging}")
    private String prometheusAlarmEnv;
    @Value(value="${server.type}")
    private String env;
    @Value(value="${alert.manager.env:staging}")
    private String alertManagerEnv;

    @Override
    @Deprecated
    public void alarmRuleSwitchPlat(AppAlarmRule oldRule, Integer newProjectId, Integer newIamId, String oldProjectName, String newProjectName) {
        Result<JsonElement> alarmRuleRemote = this.alarmService.getAlarmRuleRemote(oldRule.getAlarmId(), oldRule.getProjectId(), oldRule.getCreater());
        if (!alarmRuleRemote.isSuccess()) {
            log.error("appPlatMove update get remote rule fail!oldRule:{},newProjectId:{},newIamId:{},newProjectName:{}", new Object[]{oldRule, newProjectId, newIamId, newProjectName});
            return;
        }
        JsonElement remoteRule = (JsonElement)alarmRuleRemote.getData();
        if (remoteRule == null) {
            log.error("appPlatMove update no remote rule found!oldRule:{},newProjectId:{},newIamId:{},newProjectName:{}", new Object[]{oldRule, newProjectId, newIamId, newProjectName});
            return;
        }
        JsonObject asJsonObject = remoteRule.getAsJsonObject();
        String expr = asJsonObject.get("expr").getAsString();
        String oldApplication = oldRule.getProjectId() + "_" + oldProjectName.replaceAll("-", "_");
        String newApplication = newProjectId + "_" + newProjectName.replaceAll("-", "_");
        String newExpr = expr.replace(oldApplication, newApplication);
        asJsonObject.remove("expr");
        asJsonObject.addProperty("expr", newExpr);
        asJsonObject.remove("tree_id");
        asJsonObject.addProperty("tree_id", (Number)newIamId);
        JsonObject labels = asJsonObject.getAsJsonObject("labels");
        labels.remove("project_id");
        labels.addProperty("project_id", (Number)newProjectId);
        labels.remove("project_name");
        labels.addProperty("project_name", newProjectName);
        labels.remove("app_iam_id");
        labels.addProperty("app_iam_id", (Number)newIamId);
        Result result = this.alarmService.updateAlarm(oldRule.getAlarmId(), oldRule.getIamId(), oldRule.getCreater(), asJsonObject.toString());
        log.info("alarmRuleSwitchPlat updateAlarm request body:{},response{}", (Object)asJsonObject.toString(), (Object)new Gson().toJson((Object)result));
        if (result.isSuccess()) {
            // empty if block
        }
    }

    @Override
    public Result queryFunctionList(Integer projectId) {
        return this.appAlarmServiceExtension.queryFunctionList(projectId);
    }

    @Override
    public Result queryRulesByAppName(String appName, String userName, Integer page, Integer pageSize) {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppWithAlarmRules>> pd = new PageData<List<AppWithAlarmRules>>();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        Long aLong = this.appAlarmRuleDao.countAlarmRuleByAppName(userName, appName);
        pd.setTotal(aLong);
        List<AppWithAlarmRules> resultList = this.appAlarmRuleDao.queryRulesByAppName(userName, appName, page, pageSize);
        if (!CollectionUtils.isEmpty(resultList)) {
            for (AppWithAlarmRules appWithAlarmRule : resultList) {
                List<AppAlarmRule> alarmRules = appWithAlarmRule.getAlarmRules();
                appWithAlarmRule.setMetricMap(this.alarmPresetMetricsService.getEnumMap());
                appWithAlarmRule.setCheckDataMap(AlarmCheckDataCount.getEnumMap());
                appWithAlarmRule.setSendIntervalMap(AlarmSendInterval.getEnumMap());
                AppAlarmRule rule = new AppAlarmRule();
                rule.setIamId(appWithAlarmRule.getIamId());
                rule.setStatus(0);
                List<AppAlarmRule> rules = this.appAlarmRuleDao.query(rule, 0, Integer.MAX_VALUE);
                appWithAlarmRule.setAlarmRules(rules);
                if (CollectionUtils.isEmpty(rules)) continue;
                AppAlarmRule rule1 = rules.get(0);
                appWithAlarmRule.setCreater(rule1.getCreater());
                appWithAlarmRule.setLastUpdateTime(rule1.getUpdateTime());
                appWithAlarmRule.setRuleStatus(rule1.getRuleStatus());
            }
        }
        pd.setList(resultList);
        return Result.success(pd);
    }

    @Override
    public Result queryNoRulesConfig(String appName, String userName, Integer page, Integer pageSize) {
        if (page == null) {
            page = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        PageData<List<AppWithAlarmRules>> pd = new PageData<List<AppWithAlarmRules>>();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        Long aLong = this.appAlarmRuleDao.countAppNoAlarmRulesConfig(userName, appName);
        pd.setTotal(aLong);
        List<AppWithAlarmRules> resultList = this.appAlarmRuleDao.queryAppNoAlarmRulesConfig(userName, appName, page, pageSize);
        pd.setList(resultList);
        return Result.success(pd);
    }

    @Override
    public Result queryRulesByIamId(Integer iamId, String userName) {
        return this.appAlarmServiceExtension.queryRulesByIamId(iamId, userName);
    }

    @Override
    public Integer getAlarmConfigNumByTeslaGroup(String group) {
        AppAlarmRule rule = new AppAlarmRule();
        rule.setLabels(group);
        rule.setStatus(0);
        Long aLong = this.appAlarmRuleDao.countByExample(rule);
        return aLong == null ? 0 : aLong.intValue();
    }

    @Override
    public Result addRulesWithStrategy(AlarmRuleRequest param) {
        AppMonitor app = null;
        app = param.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? this.appMonitorDao.getByIamTreeId(param.getIamId()) : this.appMonitorDao.getMyApp(param.getProjectId(), param.getIamId(), param.getUser(), AppViewType.MyApp);
        if (app == null) {
            log.error("\u4e0d\u5b58\u5728projectId={}\u7684\u9879\u76ee", (Object)param.getProjectId());
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        AlarmStrategy strategy = this.alarmStrategyService.create(param, app);
        if (strategy == null) {
            log.error("\u89c4\u5219\u7b56\u7565\u521b\u5efa\u5931\u8d25; strategyResult={}", (Object)strategy);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        Integer strategyId = strategy.getId();
        HeraRequestMappingContext.set("strategyId", strategyId);
        param.setStrategyId(strategyId);
        return this.addRules(param, app);
    }

    @Override
    public Result batchAddRulesWithStrategy(AlarmRuleRequest param) {
        ArrayList projectsAlarmInfo = param.getProjectsAlarmInfo();
        if (projectsAlarmInfo == null) {
            projectsAlarmInfo = Lists.newArrayList();
        }
        if (param.getIamId() != null && param.getProjectId() != null) {
            ProjectAlarmInfo projectAlarmInfo = new ProjectAlarmInfo();
            projectAlarmInfo.setIamId(param.getIamId());
            projectAlarmInfo.setIamType(param.getIamType());
            projectAlarmInfo.setProjectId(param.getProjectId());
            projectsAlarmInfo.add(projectAlarmInfo);
        }
        if (CollectionUtils.isEmpty((Collection)projectsAlarmInfo)) {
            log.info("batchAddRulesWithStrategy no projectsAlarmInfo found!");
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        for (ProjectAlarmInfo t : projectsAlarmInfo) {
            param.setProjectId(t.getProjectId());
            param.setIamType(t.getIamType());
            param.setIamId(t.getIamId());
            AppMonitor app = null;
            app = param.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? this.appMonitorDao.getByIamTreeId(param.getIamId()) : this.appMonitorDao.getMyApp(param.getProjectId(), param.getIamId(), param.getUser(), AppViewType.MyApp);
            if (app == null) {
                log.error("batchAddRulesWithStrategy# current user has not permission for projectId={} param:{}", (Object)param.getProjectId(), (Object)param.toString());
                continue;
            }
            AlarmStrategy strategy = this.alarmStrategyService.create(param, app);
            if (strategy == null) {
                log.error("batchAddRulesWithStrategy remote fail; param:{},strategyResult={}", (Object)param.toString(), (Object)strategy.toString());
                continue;
            }
            Integer strategyId = strategy.getId();
            HeraRequestMappingContext.set("strategyId", strategyId);
            param.setStrategyId(strategyId);
            Result result = this.addRules(param, app);
            if (result.isSuccess()) continue;
            log.error("batchAddRulesWithStrategy#local create strategy fail! param:{},result:{}", (Object)param.toString(), (Object)new Gson().toJson((Object)result));
        }
        return Result.success();
    }

    @Override
    public Result addRules(AlarmRuleRequest param, AppMonitor app) {
        for (AlarmRuleData ruleData : param.getAlarmRules()) {
            ruleData.setIncludeEnvs(param.getIncludeEnvs());
            ruleData.setExceptEnvs(param.getExceptEnvs());
            ruleData.setIncludeZones(param.getIncludeZones());
            ruleData.setExceptZones(param.getExceptZones());
            ruleData.setIncludeContainerName(param.getIncludeContainerName());
            ruleData.setExceptContainerName(param.getExceptContainerName());
            ruleData.setAlertMembers(param.getAlertMembers());
            ruleData.setAtMembers(param.getAtMembers());
            ruleData.setIncludeFunctions(param.getIncludeFunctions());
            ruleData.setExceptFunctions(param.getExceptFunctions());
            ruleData.setIncludeModules(param.getIncludeModules());
            ruleData.setExceptModules(param.getExceptModules());
            ruleData.convertLabels();
            AppAlarmRule rule = new AppAlarmRule();
            BeanUtils.copyProperties((Object)ruleData, (Object)rule);
            StringBuilder cname = new StringBuilder();
            cname.append(param.getIamId() != null ? param.getIamId() : param.getProjectId());
            if (param.getStrategyType().intValue() == AlarmStrategyType.PAOMQL.getCode().intValue()) {
                if (rule.getMetricType() == null) {
                    rule.setMetricType(AlarmRuleMetricType.customer_promql.getCode());
                }
                if (StringUtils.isBlank((CharSequence)ruleData.getAlert())) {
                    cname.append("-").append(AlarmRuleMetricType.customer_promql.getDesc());
                } else {
                    cname.append("-").append(ruleData.getAlert());
                }
                cname.append("-").append(System.currentTimeMillis());
                rule.setCname(cname.toString());
                rule.setAlert(StringUtils.isBlank((CharSequence)rule.getAlert()) ? cname.toString() : rule.getAlert());
            } else {
                if (rule.getMetricType() == null) {
                    rule.setMetricType(AlarmRuleMetricType.preset.getCode());
                }
                cname.append("-").append(ruleData.getAlert());
                cname.append("-").append(System.currentTimeMillis());
                rule.setCname(cname.toString());
            }
            rule.setRuleType(AlarmRuleType.app_config.getCode());
            rule.setProjectId(param.getProjectId());
            rule.setIamId(param.getIamId());
            int alarmForTime = this.evaluationInterval * ruleData.getDataCount();
            String alarmForTimeS = alarmForTime + this.evaluationUnit;
            rule.setForTime(alarmForTimeS);
            rule.setRuleGroup("group" + param.getIamId());
            rule.setEnv(this.prometheusAlarmEnv);
            rule.setStatus(0);
            rule.setCreater(param.getUser());
            rule.setRuleStatus(RuleStatusType.active.getCode());
            String remark = null;
            remark = rule.getMetricType() == AlarmRuleMetricType.customer_promql.getCode() ? (StringUtils.isBlank((CharSequence)rule.getRemark()) ? param.getStrategyDesc() : rule.getRemark()) : param.getStrategyDesc();
            rule.setRemark(remark);
            rule.setCreateTime(new Date());
            rule.setUpdateTime(new Date());
            rule.setStrategyId(param.getStrategyId());
            Result result = this.alarmService.addRule(app, rule, param.getUser(), ruleData);
            if (result.getCode() != 0) {
                log.error("AppAlarmService.addRules error! remote add ruleData fail!ruleData:{}", (Object)rule.toString());
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            Integer alarmId = this.appAlarmServiceExtension.getAlarmIdByResult(result);
            rule.setAlarmId(alarmId);
            int i = this.appAlarmRuleDao.create(rule);
            if (i >= 0) continue;
            log.error("AppAlarmService.addRules error! add ruleData data fail!ruleData:{}", (Object)rule.toString());
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success(null);
    }

    @Override
    @Deprecated
    public Result editRules(List<AlarmRuleData> rules, AlarmRuleRequest param, String user, String userName) {
        Result result = this.alarmStrategyService.deleteById(user, param.getStrategyId());
        if (result.getCode() != ErrorCode.success.getCode()) {
            return result;
        }
        AppMonitor app = null;
        app = param.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? this.appMonitorDao.getByIamTreeId(param.getIamId()) : this.appMonitorDao.getMyApp(param.getProjectId(), param.getIamId(), user, AppViewType.MyApp);
        if (app == null) {
            log.error("\u4e0d\u5b58\u5728projectId={}\u7684\u9879\u76ee", (Object)param.getProjectId());
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        AlarmStrategy strategy = this.alarmStrategyService.create(param, app);
        if (strategy == null) {
            log.error("\u89c4\u5219\u7b56\u7565\u521b\u5efa\u5931\u8d25; strategyResult={}", (Object)strategy);
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        Integer strategyId = strategy.getId();
        HeraRequestMappingContext.set("strategyId", strategyId);
        param.setStrategyId(strategyId);
        return this.addRules(param, app);
    }

    @Override
    public Result delAlarmRules(List<Integer> ids, String user) {
        if (CollectionUtils.isEmpty(ids)) {
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        for (Integer id : ids) {
            AppAlarmRule rule = this.appAlarmRuleDao.getById(id);
            if (rule == null) {
                return Result.fail((ErrorCode)ErrorCode.nonExistentAlarmRule);
            }
            Result result = this.alarmService.deleteRule(rule.getAlarmId(), rule.getIamId(), user);
            if (!result.isSuccess()) {
                return Result.fail((ErrorCode)ErrorCode.DeleteJobFail);
            }
            int i = this.appAlarmRuleDao.delById(id);
            if (i >= 1) continue;
            log.error("fail to delete rule in db,id:{}", (Object)id);
            return Result.fail((ErrorCode)ErrorCode.FAIL_TO_DELETE_RULE_IN_DB);
        }
        return Result.success();
    }

    @Override
    public Result editAlarmRuleSingle(AlarmRuleData ruleData, String user) {
        if (ruleData == null) {
            log.error("editAlarmRuleSingle invalid ruleData : {} ", (Object)ruleData);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AlarmStrategy alarmStrategy = this.alarmStrategyService.getById(ruleData.getStrategyId());
        if (alarmStrategy == null) {
            log.error("editAlarmRuleSingle strategy is not exist!ruleData:{}", (Object)ruleData);
            return Result.fail((ErrorCode)ErrorCode.nonExistentStrategy);
        }
        AppMonitor app = null;
        app = alarmStrategy.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? this.appMonitorDao.getByIamTreeId(ruleData.getIamId()) : this.appMonitorDao.getMyApp(ruleData.getProjectId(), ruleData.getIamId(), user, AppViewType.MyApp);
        if (app == null) {
            log.error("\u4e0d\u5b58\u5728 owner \u4e3a user : {}\uff0c projectId={}\u7684\u9879\u76ee", (Object)user, (Object)ruleData.getProjectId());
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        ruleData.setAlertMembers(StringUtils.isBlank((CharSequence)alarmStrategy.getAlertMembers()) ? null : Arrays.asList(alarmStrategy.getAlertMembers().split(",")));
        ruleData.setAtMembers(StringUtils.isBlank((CharSequence)alarmStrategy.getAtMembers()) ? null : Arrays.asList(alarmStrategy.getAtMembers().split(",")));
        return this.editAlarmRule(ruleData, alarmStrategy, app, user);
    }

    @Override
    public Result editRulesByStrategy(AlarmRuleRequest param) {
        Result<AlarmStrategy> strategyUpdateResult;
        List<AlarmRuleData> alarmRuleDatas = param.getAlarmRules();
        if (CollectionUtils.isEmpty(alarmRuleDatas)) {
            log.error("editRules no rule data found!param:{}", (Object)param);
            return Result.fail((ErrorCode)ErrorCode.invalidParamError);
        }
        AppMonitor app = null;
        app = param.getStrategyType().equals(AlarmStrategyType.TESLA.getCode()) ? this.appMonitorDao.getByIamTreeId(param.getIamId()) : this.appMonitorDao.getMyApp(param.getProjectId(), param.getIamId(), param.getUser(), AppViewType.MyApp);
        if (app == null) {
            log.error("\u4e0d\u5b58\u5728projectId={}\u7684\u9879\u76ee", (Object)param.getProjectId());
            return Result.fail((ErrorCode)ErrorCode.NoOperPermission);
        }
        AlarmStrategy alarmStrategy = this.alarmStrategyService.getById(param.getStrategyId());
        if (alarmStrategy == null) {
            log.error("the strategy is not exist!param:{}", (Object)param.toString());
            return Result.fail((ErrorCode)ErrorCode.nonExistentStrategy);
        }
        List<AlarmRuleData> addRules = alarmRuleDatas.stream().filter(t -> t.getId() == null).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(addRules)) {
            param.setAlarmRules(addRules);
            Result result1 = this.addRules(param, app);
            if (result1.getCode() != 0) {
                return result1;
            }
        }
        if (!(this.nullToEmpty(alarmStrategy.getAlertTeam()).equals(this.nullToEmpty(param.getAlertTeam())) && this.nullToEmpty(alarmStrategy.getAlertMembers()).equals(this.nullToEmpty(String.join((CharSequence)",", param.getAlertMembers()))) && this.nullToEmpty(alarmStrategy.getAtMembers()).equals(this.nullToEmpty(String.join((CharSequence)",", param.getAtMembers() == null ? new ArrayList() : param.getAtMembers()))) && this.nullToEmpty(alarmStrategy.getEnvs()).equals(this.nullToEmpty(param.convertEnvs())) && this.nullToEmpty(alarmStrategy.getDesc()).equals(this.nullToEmpty(param.getStrategyDesc())))) {
            alarmStrategy.setDesc(param.getStrategyDesc());
            List<AlarmRuleData> updateRules = alarmRuleDatas.stream().filter(t -> t.getId() != null).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(updateRules)) {
                AppMonitor appMonitor = app;
                Optional failResult = Optional.empty();
                updateRules.forEach(ruleData -> {
                    ruleData.setIncludeEnvs(param.getIncludeEnvs());
                    ruleData.setExceptEnvs(param.getExceptEnvs());
                    ruleData.setIncludeZones(param.getIncludeZones());
                    ruleData.setExceptZones(param.getExceptZones());
                    ruleData.setIncludeContainerName(param.getIncludeContainerName());
                    ruleData.setExceptContainerName(param.getExceptContainerName());
                    ruleData.setIncludeModules(param.getIncludeModules());
                    ruleData.setExceptModules(param.getExceptModules());
                    ruleData.setIncludeFunctions(param.getIncludeFunctions());
                    ruleData.setExceptFunctions(param.getExceptFunctions());
                    ruleData.setAlertMembers(param.getAlertMembers());
                    ruleData.setAtMembers(param.getAtMembers());
                    ruleData.setAlertTeam(param.getAlertTeam());
                    Result result = this.editAlarmRule((AlarmRuleData)ruleData, alarmStrategy, appMonitor, param.getUser());
                    if (!result.isSuccess()) {
                        failResult.orElse(result);
                        return;
                    }
                });
                if (failResult.isPresent()) {
                    return (Result)failResult.get();
                }
            }
        }
        if ((strategyUpdateResult = this.alarmStrategyService.updateByParam(param)).getCode() != ErrorCode.success.getCode()) {
            log.error("update strategy in db fail!param:{}", (Object)param.toString());
            return Result.fail((ErrorCode)ErrorCode.ALARM_STRATEGY_INFO_UPDATE_FAIL);
        }
        return Result.success(null);
    }

    @Override
    public Result editAlarmRule(AlarmRuleData ruleData, AlarmStrategy alarmStrategy, AppMonitor app, String user) {
        AppAlarmRule rule = this.appAlarmRuleDao.getById(ruleData.getId());
        if (rule == null) {
            log.info("edit alarm rule,no data found in db!ruleData:{}", (Object)ruleData);
            return Result.fail((ErrorCode)ErrorCode.nonExistentAlarmRule);
        }
        ruleData.convertLabels();
        rule.setOp(ruleData.getOp());
        rule.setValue(ruleData.getValue());
        int alarmForTime = this.evaluationInterval * ruleData.getDataCount();
        String alarmForTimeS = alarmForTime + this.evaluationUnit;
        rule.setForTime(alarmForTimeS);
        rule.setDataCount(ruleData.getDataCount());
        rule.setPriority(ruleData.getPriority());
        rule.setSendInterval(ruleData.getSendInterval());
        rule.setAlertTeam(ruleData.getAlertTeam());
        rule.setLabels(ruleData.getLabels());
        String remark = null;
        remark = rule.getMetricType() == AlarmRuleMetricType.customer_promql.getCode() ? (StringUtils.isNotBlank((CharSequence)ruleData.getRemark()) ? ruleData.getRemark() : alarmStrategy.getDesc()) : alarmStrategy.getDesc();
        rule.setRemark(remark);
        rule.setUpdateTime(new Date());
        Result result = this.alarmService.editRule(rule, ruleData, app, user);
        if (result.getCode() != 0) {
            log.error("AppAlarmService.editRules error! remote add ruleData fail!ruleData:{}", (Object)rule.toString());
            return Result.fail((ErrorCode)ErrorCode.UpdateJobFail);
        }
        log.info("appAlarmRuleDao.updateByIdSelective rule:{}", (Object)new Gson().toJson((Object)rule));
        int i = this.appAlarmRuleDao.updateByIdSelective(rule);
        if (i < 1) {
            log.error("AppAlarmService.editRules save db fail!ruleData:{}", (Object)rule.toString());
            return Result.fail((ErrorCode)ErrorCode.ALARM_RULE_INFO_UPDATE_FAIL);
        }
        return Result.success((Object)"");
    }

    private String nullToEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    @Override
    public Result deleteRulesByIamId(Integer iamId, Integer strategyId, String user) {
        AppAlarmRule rulequery = new AppAlarmRule();
        rulequery.setStatus(0);
        if (iamId != null) {
            rulequery.setIamId(iamId);
        }
        rulequery.setStrategyId(strategyId);
        List<AppAlarmRule> delRules = this.appAlarmRuleDao.query(rulequery, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty(delRules)) {
            log.info("AppAlarmService.deleteRulesByIamId no data found! iamId : {},user:{}", (Object)iamId, (Object)user);
            return Result.success(null);
        }
        for (AppAlarmRule rule : delRules) {
            int delete;
            Result result = this.alarmService.deleteRule(rule.getAlarmId(), iamId, user);
            if (result.getCode() == 0) {
                delete = this.appAlarmRuleDao.delete(rule);
                if (delete >= 1) continue;
                log.error("AppAlarmService.deleteRulesByIamId delete local database fail!iamId : {},user:{}", (Object)iamId, (Object)user);
                return Result.fail((ErrorCode)ErrorCode.unknownError);
            }
            if (result.getCode() == 404) {
                log.error("AppAlarmService.deleteRulesByIamId delete remote data,no data found!iamId : {},user:{}", (Object)iamId, (Object)user);
                delete = this.appAlarmRuleDao.delete(rule);
                if (delete < 1) {
                    log.error("AppAlarmService.deleteRulesByIamId delete local database fail!iamId : {},user:{}", (Object)iamId, (Object)user);
                    return Result.fail((ErrorCode)ErrorCode.unknownError);
                }
                Result.success((Object)"");
            }
            log.error("AppAlarmService.deleteRulesByIamId delete remote data fail!iamId : {},user:{}", (Object)iamId, (Object)user);
            Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)"");
    }

    @Override
    public Result enabledRules(Integer iamId, Integer strategyId, Integer pauseStatus, String user) {
        AppAlarmRule rulequery = new AppAlarmRule();
        rulequery.setStatus(0);
        if (iamId != null) {
            rulequery.setIamId(iamId);
        }
        rulequery.setStrategyId(strategyId);
        List<AppAlarmRule> delRules = this.appAlarmRuleDao.query(rulequery, 0, Integer.MAX_VALUE);
        if (CollectionUtils.isEmpty(delRules)) {
            log.info("AppAlarmService.enabledRules no data found! iamId : {},user:{}", (Object)iamId, (Object)user);
            return Result.success(null);
        }
        for (AppAlarmRule rule : delRules) {
            Result result = this.alarmService.enabledRule(rule.getAlarmId(), pauseStatus, iamId, user);
            if (result.getCode() == 0) {
                AppAlarmRule condition = new AppAlarmRule();
                condition.setIamId(rule.getIamId());
                condition.setStatus(0);
                AppAlarmRule value = new AppAlarmRule();
                value.setRuleStatus(pauseStatus);
                try {
                    int update = this.appAlarmRuleDao.update(condition, value);
                    if (update >= 1) continue;
                    log.info("AppAlarmService.enabledRules update data failed!");
                    return Result.fail((ErrorCode)ErrorCode.unknownError);
                }
                catch (Exception e) {
                    log.error("AppAlarmService.enabledRules error!{}", (Object)e.getMessage(), (Object)e);
                    return Result.fail((ErrorCode)ErrorCode.unknownError);
                }
            }
            log.error("AppAlarmService.enabledRules update remote data fail!iamId : {},user:{}", (Object)iamId, (Object)user);
            Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)"");
    }

    @Override
    public Result queryTemplate(AppAlarmRuleTemplateQuery query) {
        Integer pageSize;
        Integer page;
        if (StringUtils.isNotBlank((CharSequence)query.getCreater())) {
            query.setCreater(query.getCreater());
        }
        if ((page = query.getPage()) == null || page == 0) {
            page = 1;
        }
        if ((pageSize = query.getPageSize()) == null) {
            pageSize = 10;
        }
        Integer start = (page - 1) * pageSize;
        Long dataTotal = this.appAlarmRuleTemplateDao.getDataTotal(query);
        PageData pd = new PageData();
        pd.setPage(page);
        pd.setPageSize(pageSize);
        pd.setTotal(dataTotal);
        ArrayList<AlarmTemplateResponse> resultList = new ArrayList<AlarmTemplateResponse>();
        List<AppAlarmRuleTemplate> list = this.appAlarmRuleTemplateDao.query(query, start, pageSize);
        if (CollectionUtils.isEmpty(list)) {
            pd.setList(resultList);
        }
        AppAlarmRule rule = new AppAlarmRule();
        rule.setRuleType(AlarmRuleType.template.getCode());
        rule.setStatus(0);
        for (AppAlarmRuleTemplate template : list) {
            rule.setTemplateId(template.getId());
            List<AppAlarmRule> rules = this.appAlarmRuleDao.query(rule, 0, Integer.MAX_VALUE);
            AlarmTemplateResponse response = new AlarmTemplateResponse();
            response.setTemplate(template);
            response.setAlarmRules(rules);
            resultList.add(response);
        }
        pd.setList(resultList);
        return Result.success(pd);
    }

    @Override
    public Result getTemplateById(Integer id) {
        AppAlarmRuleTemplate template = this.appAlarmRuleTemplateDao.getById(id);
        if (template == null) {
            log.info("getTemplateById no data found id : {}", (Object)id);
            return Result.success(null);
        }
        AppAlarmRule rule = new AppAlarmRule();
        rule.setRuleType(AlarmRuleType.template.getCode());
        rule.setStatus(0);
        rule.setTemplateId(template.getId());
        List<AppAlarmRule> rules = this.appAlarmRuleDao.query(rule, 0, Integer.MAX_VALUE);
        AlarmTemplateResponse response = new AlarmTemplateResponse();
        response.setTemplate(template);
        response.setAlarmRules(rules);
        return Result.success((Object)response);
    }

    @Override
    public Result getTemplateByCreater(String user) {
        AppAlarmRuleTemplateQuery query = new AppAlarmRuleTemplateQuery();
        query.setCreater(user);
        List<AppAlarmRuleTemplate> list = this.appAlarmRuleTemplateDao.query(query, 0, Integer.MAX_VALUE);
        return Result.success(list);
    }

    @Override
    public Result addTemplate(AlarmRuleTemplateRequest request, String user) {
        AppAlarmRuleTemplate alarmRuleTemplate = request.getTemplate();
        alarmRuleTemplate.setCreater(user);
        alarmRuleTemplate.setType(AlarmRuleTemplateType.user.getCode());
        int i = this.appAlarmRuleTemplateDao.create(alarmRuleTemplate);
        if (i < 1) {
            log.error("AppAlarmService.addTemplate,insert template data failed!");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        List<AppAlarmRule> alarmRules = request.getAlarmRules();
        boolean b = this.saveTemplateRules(alarmRules, alarmRuleTemplate.getId(), user);
        if (!b) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)"");
    }

    @Override
    public Result editTemplate(AlarmRuleTemplateRequest request, String user) {
        AppAlarmRuleTemplate alarmRuleTemplate = request.getTemplate();
        AppAlarmRuleTemplate update = new AppAlarmRuleTemplate();
        update.setId(alarmRuleTemplate.getId());
        update.setRemark(alarmRuleTemplate.getRemark());
        update.setName(alarmRuleTemplate.getName());
        update.setStrategyType(alarmRuleTemplate.getStrategyType());
        int i = this.appAlarmRuleTemplateDao.update(update);
        if (i < 1) {
            log.error("AppAlarmService.editTemplate,update template data failed!");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        AppAlarmRule rule = new AppAlarmRule();
        rule.setTemplateId(alarmRuleTemplate.getId());
        rule.setRuleType(0);
        this.appAlarmRuleDao.delete(rule);
        List<AppAlarmRule> alarmRules = request.getAlarmRules();
        boolean b = this.saveTemplateRules(alarmRules, alarmRuleTemplate.getId(), user);
        if (!b) {
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        return Result.success((Object)"");
    }

    @Override
    public Result deleteTemplate(Integer templateId) {
        int i = this.appAlarmRuleTemplateDao.deleteById(templateId);
        if (i < 1) {
            log.error("AppAlarmService.deleteTemplate,delete template data failed!");
            return Result.fail((ErrorCode)ErrorCode.unknownError);
        }
        AppAlarmRule rule = new AppAlarmRule();
        rule.setTemplateId(templateId);
        rule.setRuleType(0);
        int delete = this.appAlarmRuleDao.delete(rule);
        if (delete < 1) {
            log.info("AppAlarmService.deleteTemplate,delete template rules no data found!");
        }
        return Result.success((Object)"");
    }

    private boolean saveTemplateRules(List<AppAlarmRule> alarmRules, Integer templateId, String user) {
        if (CollectionUtils.isEmpty(alarmRules)) {
            log.info("AppAlarmService.saveTemplateRules,alarmRules is empty!templateId : {}", (Object)templateId);
            return true;
        }
        for (AppAlarmRule next : alarmRules) {
            next.setCreater(user);
            next.setTemplateId(templateId);
            next.setRuleType(AlarmRuleType.template.getCode());
            next.setRuleStatus(0);
            next.setForTime(next.getDataCount() * 30 + "s");
            next.setStatus(0);
            next.setCreateTime(new Date());
            next.setUpdateTime(new Date());
        }
        int i1 = this.appAlarmRuleDao.batchInsert(alarmRules);
        if (i1 < 1) {
            log.error("AppAlarmService.saveTemplateRules,insert rules data failed! templateId:{},alarmRules:{}", (Object)templateId, alarmRules);
            return false;
        }
        return true;
    }
}

