/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.facebook.thrift.TBase;
import com.facebook.thrift.TBaseHelper;
import com.facebook.thrift.TException;
import com.facebook.thrift.meta_data.FieldMetaData;
import com.facebook.thrift.meta_data.FieldValueMetaData;
import com.facebook.thrift.meta_data.StructMetaData;
import com.facebook.thrift.protocol.TField;
import com.facebook.thrift.protocol.TProtocol;
import com.facebook.thrift.protocol.TProtocolUtil;
import com.facebook.thrift.protocol.TStruct;
import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.QueryStatus;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class QueryDesc
implements TBase,
Serializable,
Cloneable,
Comparable<QueryDesc> {
    private static final TStruct STRUCT_DESC = new TStruct("QueryDesc");
    private static final TField START_TIME_FIELD_DESC = new TField("start_time", 10, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 8, 2);
    private static final TField DURATION_FIELD_DESC = new TField("duration", 10, 3);
    private static final TField QUERY_FIELD_DESC = new TField("query", 11, 4);
    private static final TField GRAPH_ADDR_FIELD_DESC = new TField("graph_addr", 12, 5);
    public long start_time;
    public QueryStatus status;
    public long duration;
    public byte[] query;
    public HostAddr graph_addr;
    public static final int START_TIME = 1;
    public static final int STATUS = 2;
    public static final int DURATION = 3;
    public static final int QUERY = 4;
    public static final int GRAPH_ADDR = 5;
    private static final int __START_TIME_ISSET_ID = 0;
    private static final int __DURATION_ISSET_ID = 1;
    private BitSet __isset_bit_vector = new BitSet(2);
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public QueryDesc() {
    }

    public QueryDesc(long start_time, QueryStatus status, long duration, byte[] query, HostAddr graph_addr) {
        this();
        this.start_time = start_time;
        this.setStart_timeIsSet(true);
        this.status = status;
        this.duration = duration;
        this.setDurationIsSet(true);
        this.query = query;
        this.graph_addr = graph_addr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public QueryDesc(QueryDesc other) {
        this.__isset_bit_vector.clear();
        this.__isset_bit_vector.or(other.__isset_bit_vector);
        this.start_time = TBaseHelper.deepCopy(other.start_time);
        if (other.isSetStatus()) {
            this.status = TBaseHelper.deepCopy(other.status);
        }
        this.duration = TBaseHelper.deepCopy(other.duration);
        if (other.isSetQuery()) {
            this.query = TBaseHelper.deepCopy(other.query);
        }
        if (other.isSetGraph_addr()) {
            this.graph_addr = TBaseHelper.deepCopy(other.graph_addr);
        }
    }

    @Override
    public QueryDesc deepCopy() {
        return new QueryDesc(this);
    }

    public long getStart_time() {
        return this.start_time;
    }

    public QueryDesc setStart_time(long start_time) {
        this.start_time = start_time;
        this.setStart_timeIsSet(true);
        return this;
    }

    public void unsetStart_time() {
        this.__isset_bit_vector.clear(0);
    }

    public boolean isSetStart_time() {
        return this.__isset_bit_vector.get(0);
    }

    public void setStart_timeIsSet(boolean __value) {
        this.__isset_bit_vector.set(0, __value);
    }

    public QueryStatus getStatus() {
        return this.status;
    }

    public QueryDesc setStatus(QueryStatus status) {
        this.status = status;
        return this;
    }

    public void unsetStatus() {
        this.status = null;
    }

    public boolean isSetStatus() {
        return this.status != null;
    }

    public void setStatusIsSet(boolean __value) {
        if (!__value) {
            this.status = null;
        }
    }

    public long getDuration() {
        return this.duration;
    }

    public QueryDesc setDuration(long duration) {
        this.duration = duration;
        this.setDurationIsSet(true);
        return this;
    }

    public void unsetDuration() {
        this.__isset_bit_vector.clear(1);
    }

    public boolean isSetDuration() {
        return this.__isset_bit_vector.get(1);
    }

    public void setDurationIsSet(boolean __value) {
        this.__isset_bit_vector.set(1, __value);
    }

    public byte[] getQuery() {
        return this.query;
    }

    public QueryDesc setQuery(byte[] query) {
        this.query = query;
        return this;
    }

    public void unsetQuery() {
        this.query = null;
    }

    public boolean isSetQuery() {
        return this.query != null;
    }

    public void setQueryIsSet(boolean __value) {
        if (!__value) {
            this.query = null;
        }
    }

    public HostAddr getGraph_addr() {
        return this.graph_addr;
    }

    public QueryDesc setGraph_addr(HostAddr graph_addr) {
        this.graph_addr = graph_addr;
        return this;
    }

    public void unsetGraph_addr() {
        this.graph_addr = null;
    }

    public boolean isSetGraph_addr() {
        return this.graph_addr != null;
    }

    public void setGraph_addrIsSet(boolean __value) {
        if (!__value) {
            this.graph_addr = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetStart_time();
                    break;
                }
                this.setStart_time((Long)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetStatus();
                    break;
                }
                this.setStatus((QueryStatus)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetDuration();
                    break;
                }
                this.setDuration((Long)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetQuery();
                    break;
                }
                this.setQuery((byte[])__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetGraph_addr();
                    break;
                }
                this.setGraph_addr((HostAddr)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return new Long(this.getStart_time());
            }
            case 2: {
                return this.getStatus();
            }
            case 3: {
                return new Long(this.getDuration());
            }
            case 4: {
                return this.getQuery();
            }
            case 5: {
                return this.getGraph_addr();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof QueryDesc)) {
            return false;
        }
        QueryDesc that = (QueryDesc)_that;
        if (!TBaseHelper.equalsNobinary(this.start_time, that.start_time)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetStatus(), that.isSetStatus(), this.status, that.status)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.duration, that.duration)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetQuery(), that.isSetQuery(), this.query, that.query)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetGraph_addr(), that.isSetGraph_addr(), this.graph_addr, that.graph_addr);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.start_time, this.status, this.duration, this.query, this.graph_addr});
    }

    @Override
    public int compareTo(QueryDesc other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetStart_time()).compareTo(other.isSetStart_time());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.start_time, other.start_time);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatus()).compareTo(other.isSetStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.status, other.status);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDuration()).compareTo(other.isSetDuration());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.duration, other.duration);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetQuery()).compareTo(other.isSetQuery());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.query, other.query);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGraph_addr()).compareTo(other.isSetGraph_addr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.graph_addr, other.graph_addr);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 10) {
                        this.start_time = iprot.readI64();
                        this.setStart_timeIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.status = QueryStatus.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 10) {
                        this.duration = iprot.readI64();
                        this.setDurationIsSet(true);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 11) {
                        this.query = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 12) {
                        this.graph_addr = new HostAddr();
                        this.graph_addr.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        oprot.writeFieldBegin(START_TIME_FIELD_DESC);
        oprot.writeI64(this.start_time);
        oprot.writeFieldEnd();
        if (this.status != null) {
            oprot.writeFieldBegin(STATUS_FIELD_DESC);
            oprot.writeI32(this.status == null ? 0 : this.status.getValue());
            oprot.writeFieldEnd();
        }
        oprot.writeFieldBegin(DURATION_FIELD_DESC);
        oprot.writeI64(this.duration);
        oprot.writeFieldEnd();
        if (this.query != null) {
            oprot.writeFieldBegin(QUERY_FIELD_DESC);
            oprot.writeBinary(this.query);
            oprot.writeFieldEnd();
        }
        if (this.graph_addr != null) {
            oprot.writeFieldBegin(GRAPH_ADDR_FIELD_DESC);
            this.graph_addr.write(oprot);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("QueryDesc");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("start_time");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getStart_time(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("status");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getStatus() == null) {
            sb.append("null");
        } else {
            String status_name;
            String string = status_name = this.getStatus() == null ? "null" : this.getStatus().name();
            if (status_name != null) {
                sb.append(status_name);
                sb.append(" (");
            }
            sb.append(this.getStatus());
            if (status_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("duration");
        sb.append(space);
        sb.append(":").append(space);
        sb.append(TBaseHelper.toString(this.getDuration(), indent + 1, prettyPrint));
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("query");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getQuery() == null) {
            sb.append("null");
        } else {
            int __query_size = Math.min(this.getQuery().length, 128);
            for (int i = 0; i < __query_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getQuery()[i]).length() > 1 ? Integer.toHexString(this.getQuery()[i]).substring(Integer.toHexString(this.getQuery()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getQuery()[i]).toUpperCase());
            }
            if (this.getQuery().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("graph_addr");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGraph_addr() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getGraph_addr(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("start_time", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(2, new FieldMetaData("status", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("duration", 3, new FieldValueMetaData(10)));
        tmpMetaDataMap.put(4, new FieldMetaData("query", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(5, new FieldMetaData("graph_addr", 3, new StructMetaData(12, HostAddr.class)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(QueryDesc.class, metaDataMap);
    }

    public static class Builder {
        private long start_time;
        private QueryStatus status;
        private long duration;
        private byte[] query;
        private HostAddr graph_addr;
        BitSet __optional_isset = new BitSet(2);

        public Builder setStart_time(long start_time) {
            this.start_time = start_time;
            this.__optional_isset.set(0, true);
            return this;
        }

        public Builder setStatus(QueryStatus status) {
            this.status = status;
            return this;
        }

        public Builder setDuration(long duration) {
            this.duration = duration;
            this.__optional_isset.set(1, true);
            return this;
        }

        public Builder setQuery(byte[] query) {
            this.query = query;
            return this;
        }

        public Builder setGraph_addr(HostAddr graph_addr) {
            this.graph_addr = graph_addr;
            return this;
        }

        public QueryDesc build() {
            QueryDesc result = new QueryDesc();
            if (this.__optional_isset.get(0)) {
                result.setStart_time(this.start_time);
            }
            result.setStatus(this.status);
            if (this.__optional_isset.get(1)) {
                result.setDuration(this.duration);
            }
            result.setQuery(this.query);
            result.setGraph_addr(this.graph_addr);
            return result;
        }
    }
}

