/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.mongo.v3_1;

import com.mongodb.event.CommandFailedEvent;
import com.mongodb.event.CommandListener;
import com.mongodb.event.CommandStartedEvent;
import com.mongodb.event.CommandSucceededEvent;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.mongo.v3_1.ContextAndRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class TracingCommandListener
implements CommandListener {
    private final Instrumenter<CommandStartedEvent, Void> instrumenter;
    private final Map<Integer, ContextAndRequest> requestMap;

    TracingCommandListener(Instrumenter<CommandStartedEvent, Void> instrumenter) {
        this.instrumenter = instrumenter;
        this.requestMap = new ConcurrentHashMap<Integer, ContextAndRequest>();
    }

    public void commandStarted(CommandStartedEvent event) {
        Context parentContext = Context.current();
        if (this.instrumenter.shouldStart(parentContext, (Object)event)) {
            Context context = this.instrumenter.start(parentContext, (Object)event);
            this.requestMap.put(event.getRequestId(), ContextAndRequest.create(context, event));
        }
    }

    public void commandSucceeded(CommandSucceededEvent event) {
        ContextAndRequest contextAndRequest = this.requestMap.remove(event.getRequestId());
        if (contextAndRequest != null) {
            this.instrumenter.end(contextAndRequest.getContext(), (Object)contextAndRequest.getRequest(), null, null);
        }
    }

    public void commandFailed(CommandFailedEvent event) {
        ContextAndRequest contextAndRequest = this.requestMap.remove(event.getRequestId());
        if (contextAndRequest != null) {
            this.instrumenter.end(contextAndRequest.getContext(), (Object)contextAndRequest.getRequest(), null, event.getThrowable());
        }
    }
}

