/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.alert.notice.impl;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hertzbeat.alert.notice.AlertNoticeException;
import org.apache.hertzbeat.alert.notice.impl.AbstractAlertNotifyHandlerImpl;
import org.apache.hertzbeat.alert.notice.impl.CommonRobotNotifyResp;
import org.apache.hertzbeat.common.entity.alerter.GroupAlert;
import org.apache.hertzbeat.common.entity.alerter.NoticeReceiver;
import org.apache.hertzbeat.common.entity.alerter.NoticeTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class GotifyAlertNotifyHandlerImpl
extends AbstractAlertNotifyHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(GotifyAlertNotifyHandlerImpl.class);

    @Override
    public void send(NoticeReceiver receiver, NoticeTemplate noticeTemplate, GroupAlert alert) throws AlertNoticeException {
        try {
            GotifyWebHookDto gotifyWebHookDto = new GotifyWebHookDto();
            gotifyWebHookDto.setTitle(this.bundle.getString("alerter.notify.title"));
            gotifyWebHookDto.setMessage(this.renderContent(noticeTemplate, alert));
            GotifyWebHookDto.ClientDisplay clientDisplay = new GotifyWebHookDto.ClientDisplay();
            clientDisplay.setContentType("text/markdown");
            GotifyWebHookDto.Extras extras = new GotifyWebHookDto.Extras();
            extras.setClientDisplay(clientDisplay);
            gotifyWebHookDto.setExtras(extras);
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HttpEntity httpEntity = new HttpEntity((Object)gotifyWebHookDto, (MultiValueMap)headers);
            String webHookUrl = String.format(this.alerterProperties.getGotifyWebhookUrl(), receiver.getGotifyToken());
            ResponseEntity responseEntity = this.restTemplate.postForEntity(webHookUrl, (Object)httpEntity, CommonRobotNotifyResp.class, new Object[0]);
            if (responseEntity.getStatusCode() != HttpStatus.OK) {
                log.warn("Send Gotify webHook: {} Failed: {}", (Object)webHookUrl, responseEntity.getBody());
                throw new AlertNoticeException("Http StatusCode " + responseEntity.getStatusCode());
            }
            log.debug("Send Gotify webHook: {} Success", (Object)webHookUrl);
        }
        catch (Exception e) {
            throw new AlertNoticeException("[Gotify Notify Error] " + e.getMessage());
        }
    }

    @Override
    public byte type() {
        return 13;
    }

    protected static class GotifyWebHookDto {
        private String title;
        private String message;
        private Extras extras;

        public String getTitle() {
            return this.title;
        }

        public String getMessage() {
            return this.message;
        }

        public Extras getExtras() {
            return this.extras;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public void setExtras(Extras extras) {
            this.extras = extras;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GotifyWebHookDto)) {
                return false;
            }
            GotifyWebHookDto other = (GotifyWebHookDto)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            Extras this$extras = this.getExtras();
            Extras other$extras = other.getExtras();
            return !(this$extras == null ? other$extras != null : !((Object)this$extras).equals(other$extras));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GotifyWebHookDto;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            Extras $extras = this.getExtras();
            result = result * 59 + ($extras == null ? 43 : ((Object)$extras).hashCode());
            return result;
        }

        public String toString() {
            return "GotifyAlertNotifyHandlerImpl.GotifyWebHookDto(title=" + this.getTitle() + ", message=" + this.getMessage() + ", extras=" + this.getExtras() + ")";
        }

        public static class Extras {
            @JsonProperty(value="client::display")
            private ClientDisplay clientDisplay;

            public ClientDisplay getClientDisplay() {
                return this.clientDisplay;
            }

            @JsonProperty(value="client::display")
            public void setClientDisplay(ClientDisplay clientDisplay) {
                this.clientDisplay = clientDisplay;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Extras)) {
                    return false;
                }
                Extras other = (Extras)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                ClientDisplay this$clientDisplay = this.getClientDisplay();
                ClientDisplay other$clientDisplay = other.getClientDisplay();
                return !(this$clientDisplay == null ? other$clientDisplay != null : !((Object)this$clientDisplay).equals(other$clientDisplay));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Extras;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                ClientDisplay $clientDisplay = this.getClientDisplay();
                result = result * 59 + ($clientDisplay == null ? 43 : ((Object)$clientDisplay).hashCode());
                return result;
            }

            public String toString() {
                return "GotifyAlertNotifyHandlerImpl.GotifyWebHookDto.Extras(clientDisplay=" + this.getClientDisplay() + ")";
            }
        }

        public static class ClientDisplay {
            private String contentType;

            public String getContentType() {
                return this.contentType;
            }

            public void setContentType(String contentType) {
                this.contentType = contentType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ClientDisplay)) {
                    return false;
                }
                ClientDisplay other = (ClientDisplay)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$contentType = this.getContentType();
                String other$contentType = other.getContentType();
                return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof ClientDisplay;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $contentType = this.getContentType();
                result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
                return result;
            }

            public String toString() {
                return "GotifyAlertNotifyHandlerImpl.GotifyWebHookDto.ClientDisplay(contentType=" + this.getContentType() + ")";
            }
        }
    }
}

