/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.trino.connector.catalog.hive;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.type.CharType;
import io.trino.spi.type.VarcharType;
import org.apache.gravitino.rel.types.Type;
import org.apache.gravitino.rel.types.Types;
import org.apache.gravitino.trino.connector.GravitinoErrorCode;
import org.apache.gravitino.trino.connector.util.GeneralDataTypeTransformer;

public class HiveDataTypeTransformer
extends GeneralDataTypeTransformer {
    private static final int HIVE_VARCHAR_MAX_LENGTH = 65535;
    private static final int HIVE_CHAR_MAX_LENGTH = 255;

    @Override
    public io.trino.spi.type.Type getTrinoType(Type type) {
        if (Type.Name.TIMESTAMP == type.name() && ((Types.TimestampType)type).hasTimeZone() || Type.Name.TIME == type.name()) {
            throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_UNSUPPORTED_GRAVITINO_DATATYPE, "Unsupported gravitino datatype: " + String.valueOf(type));
        }
        return super.getTrinoType(type);
    }

    @Override
    public Type getGravitinoType(io.trino.spi.type.Type type) {
        Class<?> typeClass = type.getClass();
        if (typeClass == VarcharType.class) {
            VarcharType varcharType = (VarcharType)type;
            if (varcharType.getLength().isEmpty()) {
                return Types.StringType.get();
            }
            int length = (Integer)varcharType.getLength().get();
            if (length > 65535) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Hive does not support the datatype VARCHAR with the length greater than 65535, you can use varchar without length instead");
            }
            return Types.VarCharType.of((int)length);
        }
        if (typeClass == CharType.class) {
            CharType charType = (CharType)type;
            if (charType.getLength() > 255) {
                throw new TrinoException((ErrorCodeSupplier)GravitinoErrorCode.GRAVITINO_ILLEGAL_ARGUMENT, "Hive does not support the datatype CHAR with the length greater than 255");
            }
            return Types.FixedCharType.of((int)charType.getLength());
        }
        return super.getGravitinoType(type);
    }
}

