# 产品简介
## GeaFlow起源

早期的大数据分析主要以离线处理为主，以Hadoop为代表的技术栈很好的解决了大规模数据的分析问题。然而数据处理的时效性不足，
很难满足高实时需求的场景。以Storm为代表的流式计算引擎的出现则很好的解决了数据实时处理的问题，提高了数据处理的时效性。
然而，Storm本身不提供状态管理的能力， 对于聚合等有状态的计算显得无能为力。Flink
的出现很好的弥补了这一短板，通过引入状态管理以及Checkpoint机制，实现了高效的有状态流计算能力。

随着数据实时处理场景的丰富，尤其是在实时数仓场景下，实时关系运算(即Stream Join)
越来越多的成为数据实时化的难点。Flink虽然具备优秀的状态管理能和出色的性能，然而在处理Join运算，尤其是3度以上Join时，
性能瓶颈越来越明显。由于需要在Join两端存放各个输入的数据状态，当Join变多时，状态的数据量急剧扩大，性能也变的难以接受。
产生这个问题的本质原因是Flink等流计算系统以表作为数据模型，而表模型本身是一个二维结构，不包含关系的定义和关系的存储，
在处理关系运算时只能通过Join运算方式实现，成本很高。

在蚂蚁的大数据应用场景中，尤其是金融风控、实时数仓等场景下，存在大量Join运算，如何提高Join
的时效性和性能成为我们面临的重要挑战，为此我们引入了图模型。图模型是一种以点边结构描述实体关系的数据模型，在图模型里面，点代表实体，
边代表关系，数据存储层面点边存放在一起。因此，图模型天然定义了数据的关系同时存储层面物化了点边关系。基于图模型，我们实现了新一代实时计算
引擎GeaFlow，很好的解决了复杂关系运算实时化的问题。目前GeaFlow已广泛应用于数仓加速、金融风控、知识图谱以及社交网络等场景。

## 技术架构

GeaFlow整体架构如下所示：

![GeaFlow架构](../../static/img/geaflow_arch_new.png)

* [DSL层](4.concepts/2.dsl_principle.md)：即语言层。GeaFlow设计了SQL+GQL的融合分析语言，支持对表模型和图模型统一处理。
* [Framework层](4.concepts/3.framework_principle.md)：即框架层。GeaFlow设计了面向Graph和Stream的两套API支持流、批、图融合计算，并实现了基于Cycle的统一分布式调度模型。
* [State层](4.concepts/4.state_principle.md)：即存储层。GeaFlow设计了面向Graph和KV的两套API支持表数据和图数据的混合存储，整体采用了Sharing Nothing的设计，并支持将数据持久化到远程存储。
* [Console平台](4.concepts/5.console_principle.md)：GeaFlow提供了一站式图研发平台，实现了图数据的建模、加工、分析能力，并提供了图作业的运维管控支持。
* **执行环境**：GeaFlow可以运行在多种异构执行环境，如K8S、Ray以及本地模式。

## 应用场景

### 实时数仓加速
数仓场景存在大量Join运算，在DWD层往往需要将多张表展开成一张大宽表，以加速后续查询。当Join的表数量变多时，传统的实时计算引擎很难
保证Join的时效性和性能，这也成为目前实时数仓领域一个棘手的问题。基于GeaFlow的实时图计算引擎，可以很好的解决这方面的问题。
GeaFlow以图作为数据模型，替代DWD层的宽表，可以实现数据实时构图，同时在查询阶段利用图的点边物化特性，可以极大加速关系运算的查询。

### 实时归因分析
在信息化的大背景下，对用户行为进行渠道归因和路径分析是流量分析领域中的核心所在。通过实时计算用户的有效行为路径，构建出完整的转化路径，能够快速帮助业务看清楚产品的价值，帮助运营及时调整运营思路。实时归因分析的核心要点是准确性和实效性。准确性要求在成本可控下保证用户行为路径分析的准确性;实效性则要求计算的实时性足够高，才能快速帮助业务决策。
基于GeaFlow流图计算引擎的能力可以很好的满足归因分析的准确性和时效性要求。如下图所示：
![归因分析](../../static/img/guiyin_analysis.png)
GeaFlow首先通过实时构图将用户行为日志转换成用户行为拓扑图，以用户作为图中的点，与其相关的每个行为构建成从该用户指向埋点页面的一条边.然后利用流图计算能力分析提前用户行为子图，在子图上基于归因路径匹配的规则进行匹配计算得出该成交行为相应用户的归因路径，并输出到下游系统。

### 实时反套现
在信贷风控的场景下，如何进行信用卡反套现是一个典型的风控诉求。基于现有的套现模式分析，可以看到套现是一个环路子图，如何快速，高效在大图中快速判定套现，将极大的增加风险的识别效率。以下图为例，通过将实时交易流、转账流等输入数据源转换成实时交易图，然后根据风控策略对用户交易行为做图特征分析，比如环路检查等特征计算，实时提供给决策和监控平台进行反套现行为判定。通过GeaFlow实时构图和实时图计算能力，可以快速发现套现等异常交易行为，极大降低平台风险。
![实时反套现](../../static/img/fantaoxian.png)