/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.asn1.type;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.kerby.asn1.Asn1Binder;
import org.apache.kerby.asn1.Asn1Converter;
import org.apache.kerby.asn1.Asn1Dumpable;
import org.apache.kerby.asn1.Asn1Dumper;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.Tag;
import org.apache.kerby.asn1.TaggingOption;
import org.apache.kerby.asn1.UniversalTag;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.type.AbstractAsn1Type;
import org.apache.kerby.asn1.type.Asn1Constructed;
import org.apache.kerby.asn1.type.Asn1Encodeable;
import org.apache.kerby.asn1.type.Asn1Type;

public class Asn1Any
extends AbstractAsn1Type<Asn1Type>
implements Asn1Dumpable {
    private Class<? extends Asn1Type> valueType;
    private Asn1FieldInfo decodeInfo;
    private Asn1ParseResult parseResult;
    private boolean isBlindlyDecoded = true;

    public Asn1Any() {
        super(UniversalTag.ANY);
    }

    public Asn1Any(Asn1Type anyValue) {
        this();
        this.setValue(anyValue);
    }

    @Override
    public Tag tag() {
        if (this.getValue() != null) {
            return ((Asn1Type)this.getValue()).tag();
        }
        if (this.parseResult != null) {
            return this.parseResult.tag();
        }
        return super.tag();
    }

    public void setValueType(Class<? extends Asn1Type> valueType) {
        this.valueType = valueType;
    }

    public void setDecodeInfo(Asn1FieldInfo decodeInfo) {
        this.decodeInfo = decodeInfo;
    }

    public Asn1ParseResult getParseResult() {
        return this.parseResult;
    }

    @Override
    public void encode(ByteBuffer buffer) throws IOException {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (!this.isBlindlyDecoded) {
                if (this.decodeInfo.isTagged()) {
                    TaggingOption taggingOption = this.decodeInfo.getTaggingOption();
                    theValue.taggedEncode(buffer, taggingOption);
                } else {
                    theValue.encode(buffer);
                }
            } else {
                theValue.encode(buffer);
            }
        }
    }

    @Override
    public int encodingLength() {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue != null) {
            if (!this.isBlindlyDecoded) {
                if (this.decodeInfo.isTagged()) {
                    TaggingOption taggingOption = this.decodeInfo.getTaggingOption();
                    return theValue.taggedEncodingLength(taggingOption);
                }
                return theValue.encodingLength();
            }
            return theValue.encodingLength();
        }
        return super.encodingLength();
    }

    @Override
    protected int encodingBodyLength() {
        Asn1Encodeable theValue = (Asn1Encodeable)this.getValue();
        if (theValue == null) {
            return 0;
        }
        return -1;
    }

    @Override
    public void decode(ByteBuffer content) throws IOException {
        this.setValue(null);
        super.decode(content);
    }

    @Override
    public void decode(Asn1ParseResult parseResult) throws IOException {
        this.decodeBody(parseResult);
    }

    @Override
    protected void decodeBody(Asn1ParseResult parseResult) throws IOException {
        this.parseResult = parseResult;
        if (this.valueType != null) {
            this.typeAwareDecode(this.valueType);
        } else {
            this.blindlyDecode();
        }
    }

    private void blindlyDecode() throws IOException {
        Asn1Type anyValue = Asn1Converter.convert(this.parseResult, false);
        if (this.decodeInfo != null && this.decodeInfo.isTagged()) {
            Asn1Constructed constructed = (Asn1Constructed)anyValue;
            Asn1Type innerValue = (Asn1Type)((List)constructed.getValue()).get(0);
            this.setValue(innerValue);
        } else {
            this.setValue(anyValue);
        }
        this.isBlindlyDecoded = true;
    }

    protected <T extends Asn1Type> T getValueAs(Class<T> t) {
        Asn1Type value = (Asn1Type)this.getValue();
        if (value != null && !this.isBlindlyDecoded) {
            return (T)value;
        }
        if (this.valueType != null && this.valueType != t) {
            throw new RuntimeException("Required value type isn't the same with the value type set before");
        }
        try {
            this.typeAwareDecode(t);
        }
        catch (IOException e) {
            throw new RuntimeException("Type aware decoding of Any type failed");
        }
        return (T)((Asn1Type)this.getValue());
    }

    private <T extends Asn1Type> void typeAwareDecode(Class<T> t) throws IOException {
        Asn1Type result;
        try {
            result = (Asn1Type)t.newInstance();
        }
        catch (Exception e) {
            throw new IOException("No default constructor?", e);
        }
        if (this.parseResult.isContextSpecific()) {
            Asn1Binder.bindWithTagging(this.parseResult, result, this.decodeInfo.getTaggingOption());
        } else {
            Asn1Binder.bind(this.parseResult, result);
        }
        this.setValue(result);
        this.isBlindlyDecoded = false;
    }

    @Override
    public void dumpWith(Asn1Dumper dumper, int indents) {
        Asn1Type theValue = (Asn1Type)this.getValue();
        dumper.indent(indents).append("<Any>").newLine();
        dumper.dumpType(indents, theValue);
    }
}

