/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.IOException;
import java.io.StringReader;
import java.io.UncheckedIOException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.paimon.catalog.CatalogContext;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.options.ConfigOption;
import org.apache.paimon.options.ConfigOptions;
import org.apache.paimon.options.Options;
import org.apache.paimon.options.description.DescribedEnum;
import org.apache.paimon.options.description.InlineElement;
import org.apache.paimon.options.description.TextElement;
import org.apache.paimon.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class HadoopUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HadoopUtils.class);
    public static final ConfigOption<HadoopConfigLoader> HADOOP_CONF_LOADER = ConfigOptions.key("hadoop-conf-loader").enumType(HadoopConfigLoader.class).defaultValue(HadoopConfigLoader.ALL).withDescription("Specifies the way of loading hadoop config.");
    public static final ConfigOption<Boolean> HADOOP_LOAD_DEFAULT_CONFIG = ConfigOptions.key("hadoop-load-default-config").booleanType().defaultValue(true).withDescription("Specifies whether load the default configuration from core-default.xml\u3001hdfs-default.xml, which may lead larger size for the serialization of table.");
    private static final String[] CONFIG_PREFIXES = new String[]{"hadoop."};
    public static final String HADOOP_HOME_ENV = "HADOOP_HOME";
    public static final String HADOOP_CONF_ENV = "HADOOP_CONF_DIR";
    public static final String PATH_HADOOP_CONFIG = "hadoop-conf-dir";

    public static Configuration getHadoopConfiguration(Options options) {
        Boolean loadDefaultConfig = options.get(HADOOP_LOAD_DEFAULT_CONFIG);
        if (loadDefaultConfig.booleanValue()) {
            LOG.debug("Load the default value for configuration.");
        }
        HdfsConfiguration result = new HdfsConfiguration(loadDefaultConfig.booleanValue());
        boolean foundHadoopConfiguration = false;
        HadoopConfigLoader loader = options.get(HADOOP_CONF_LOADER);
        String[] possibleHadoopConfPaths = new String[2];
        String hadoopHomeDir = System.getenv(HADOOP_HOME_ENV);
        if (hadoopHomeDir != null && loader.loadEnv()) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_HOME: {}", (Object)hadoopHomeDir);
            possibleHadoopConfPaths[0] = hadoopHomeDir + "/conf";
            possibleHadoopConfPaths[1] = hadoopHomeDir + "/etc/hadoop";
        }
        for (String possibleHadoopConfPath : possibleHadoopConfPaths) {
            if (StringUtils.isNullOrWhitespaceOnly(possibleHadoopConfPath)) continue;
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, possibleHadoopConfPath, options);
        }
        String hadoopConfDir = System.getenv(HADOOP_CONF_ENV);
        if (!StringUtils.isNullOrWhitespaceOnly(hadoopConfDir) && loader.loadEnv()) {
            LOG.debug("Searching Hadoop configuration files in HADOOP_CONF_DIR: {}", (Object)hadoopConfDir);
            boolean bl = foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfDir, options) || foundHadoopConfiguration;
        }
        if (!StringUtils.isNullOrWhitespaceOnly(hadoopConfDir = options.getString(PATH_HADOOP_CONFIG, null)) && loader.loadOption()) {
            LOG.debug("Searching Hadoop configuration files in Paimon config: {}", (Object)hadoopConfDir);
            foundHadoopConfiguration = HadoopUtils.addHadoopConfIfFound((Configuration)result, hadoopConfDir, options) || foundHadoopConfiguration;
        }
        for (String key : options.keySet()) {
            for (String prefix : CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String newKey = key.substring(prefix.length());
                String value = options.getString(key, null);
                result.set(newKey, value);
                LOG.debug("Adding Paimon config entry for {} as {}={} to Hadoop config", new Object[]{key, newKey, value});
                foundHadoopConfiguration = true;
            }
        }
        if (!foundHadoopConfiguration) {
            LOG.warn("Could not find Hadoop configuration via any of the supported methods");
        }
        return result;
    }

    public static boolean addHadoopConfIfFound(Configuration configuration, String possibleHadoopConfPath, Options options) {
        Path root = new Path(possibleHadoopConfPath);
        try {
            FileIO fileIO = FileIO.get(root, CatalogContext.create(options, configuration));
            boolean foundHadoopConfiguration = false;
            if (fileIO.exists(root)) {
                Path path = new Path(possibleHadoopConfPath, "core-site.xml");
                if (fileIO.exists(path)) {
                    HadoopUtils.readHadoopXml(fileIO.readFileUtf8(path), configuration);
                    LOG.debug("Adding " + possibleHadoopConfPath + "/core-site.xml to hadoop configuration");
                    foundHadoopConfiguration = true;
                }
                if (fileIO.exists(path = new Path(possibleHadoopConfPath, "hdfs-site.xml"))) {
                    HadoopUtils.readHadoopXml(fileIO.readFileUtf8(path), configuration);
                    LOG.debug("Adding " + possibleHadoopConfPath + "/hdfs-site.xml to hadoop configuration");
                    foundHadoopConfiguration = true;
                }
                if (fileIO.exists(path = new Path(possibleHadoopConfPath, "mapred-site.xml"))) {
                    HadoopUtils.readHadoopXml(fileIO.readFileUtf8(path), configuration);
                    LOG.debug("Adding " + possibleHadoopConfPath + "/mapred-site.xml to hadoop configuration");
                    foundHadoopConfiguration = true;
                }
            }
            return foundHadoopConfiguration;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void readHadoopXml(String xml, Configuration conf) {
        NodeList propertyNodes;
        try {
            propertyNodes = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(xml))).getElementsByTagName("property");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (int i = 0; i < propertyNodes.getLength(); ++i) {
            Node propertyNode = propertyNodes.item(i);
            if (propertyNode.getNodeType() != 1) continue;
            Element propertyElement = (Element)propertyNode;
            String key = propertyElement.getElementsByTagName("name").item(0).getTextContent();
            String value = propertyElement.getElementsByTagName("value").item(0).getTextContent();
            if (StringUtils.isNullOrWhitespaceOnly(value)) continue;
            conf.set(key, value);
        }
    }

    public static enum HadoopConfigLoader implements DescribedEnum
    {
        ALL("all", "Load Hadoop conf from environment variables and catalog option.", true, true),
        ENV("env", "Load Hadoop conf from environment variables only.", true, false),
        OPTION("option", "Load Hadoop conf from catalog or table option only.", false, true);

        private final String value;
        private final String description;
        private final boolean loadEnv;
        private final boolean loadOption;

        private HadoopConfigLoader(String value, String description, boolean loadEnv, boolean loadOption) {
            this.value = value;
            this.description = description;
            this.loadEnv = loadEnv;
            this.loadOption = loadOption;
        }

        public boolean loadEnv() {
            return this.loadEnv;
        }

        public boolean loadOption() {
            return this.loadOption;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public InlineElement getDescription() {
            return TextElement.text(this.description);
        }
    }
}

