/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.sink;

import javax.annotation.Nullable;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.schema.TableSchema;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeFamily;
import org.apache.paimon.types.RowKind;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class RowKindGenerator {
    private final int index;

    public RowKindGenerator(String field, RowType rowType) {
        this.index = rowType.getFieldNames().indexOf(field);
        if (this.index == -1) {
            throw new RuntimeException(String.format("Can not find rowkind %s in table schema: %s", field, rowType));
        }
        DataType fieldType = rowType.getTypeAt(this.index);
        Preconditions.checkArgument(fieldType.is(DataTypeFamily.CHARACTER_STRING), "only support string type for rowkind, but %s is %s", field, fieldType);
    }

    public RowKind generate(InternalRow row) {
        if (row.isNullAt(this.index)) {
            throw new RuntimeException("Row kind cannot be null.");
        }
        return RowKind.fromShortString(row.getString(this.index).toString());
    }

    @Nullable
    public static RowKindGenerator create(TableSchema schema, CoreOptions options) {
        return options.rowkindField().map(field -> new RowKindGenerator((String)field, schema.logicalRowType())).orElse(null);
    }

    public static RowKind getRowKind(@Nullable RowKindGenerator rowKindGenerator, InternalRow row) {
        return rowKindGenerator == null ? row.getRowKind() : rowKindGenerator.generate(row);
    }
}

