/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.annotation.Nullable;
import org.apache.paimon.compression.BlockCompressionFactory;
import org.apache.paimon.io.CompressedPageFileInput;
import org.apache.paimon.io.UncompressedPageFileInput;

public interface PageFileInput
extends Closeable {
    public RandomAccessFile file();

    public long uncompressBytes();

    public int pageSize();

    public byte[] readPage(int var1) throws IOException;

    public byte[] readPosition(long var1, int var3) throws IOException;

    public static PageFileInput create(File file, int pageSize, @Nullable BlockCompressionFactory compressionFactory, long uncompressBytes, @Nullable long[] compressPagePositions) throws IOException {
        RandomAccessFile accessFile = new RandomAccessFile(file, "r");
        if (compressionFactory == null) {
            return new UncompressedPageFileInput(accessFile, pageSize);
        }
        return new CompressedPageFileInput(accessFile, pageSize, compressionFactory, uncompressBytes, compressPagePositions);
    }
}

