/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.compact;

import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.apache.paimon.compact.CompactResult;
import org.apache.paimon.io.DataFileMeta;
import org.apache.paimon.operation.metrics.CompactionMetrics;
import org.apache.paimon.operation.metrics.MetricUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CompactTask
implements Callable<CompactResult> {
    private static final Logger LOG = LoggerFactory.getLogger(CompactTask.class);
    @Nullable
    private final CompactionMetrics.Reporter metricsReporter;

    public CompactTask(@Nullable CompactionMetrics.Reporter metricsReporter) {
        this.metricsReporter = metricsReporter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompactResult call() throws Exception {
        MetricUtils.safeCall(this::startTimer, LOG);
        try {
            long startMillis = System.currentTimeMillis();
            CompactResult result = this.doCompact();
            MetricUtils.safeCall(() -> {
                if (this.metricsReporter != null) {
                    this.metricsReporter.reportCompactionTime(System.currentTimeMillis() - startMillis);
                    this.metricsReporter.increaseCompactionsCompletedCount();
                    this.metricsReporter.reportCompactionInputSize(result.before().stream().map(DataFileMeta::fileSize).reduce(Long::sum).orElse(0L));
                    this.metricsReporter.reportCompactionOutputSize(result.after().stream().map(DataFileMeta::fileSize).reduce(Long::sum).orElse(0L));
                }
            }, LOG);
            if (LOG.isDebugEnabled()) {
                this.logMetric(startMillis, result.before(), result.after());
            }
            CompactResult compactResult = result;
            return compactResult;
        }
        finally {
            MetricUtils.safeCall(this::stopTimer, LOG);
            MetricUtils.safeCall(this::decreaseCompactionsQueuedCount, LOG);
        }
    }

    private void decreaseCompactionsQueuedCount() {
        if (this.metricsReporter != null) {
            this.metricsReporter.decreaseCompactionsQueuedCount();
        }
    }

    private void startTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().start();
        }
    }

    private void stopTimer() {
        if (this.metricsReporter != null) {
            this.metricsReporter.getCompactTimer().finish();
        }
    }

    protected String logMetric(long startMillis, List<DataFileMeta> compactBefore, List<DataFileMeta> compactAfter) {
        return String.format("Done compacting %d files to %d files in %dms. Rewrite input file size = %d, output file size = %d", compactBefore.size(), compactAfter.size(), System.currentTimeMillis() - startMillis, this.collectRewriteSize(compactBefore), this.collectRewriteSize(compactAfter));
    }

    protected abstract CompactResult doCompact() throws Exception;

    private long collectRewriteSize(List<DataFileMeta> files) {
        return files.stream().mapToLong(DataFileMeta::fileSize).sum();
    }
}

