/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package main

import (
	"github.com/apache/incubator-devlake/core/runner"
	"github.com/apache/incubator-devlake/plugins/pagerduty/impl"
	"github.com/spf13/cobra"
)

// PluginEntry Export a variable named PluginEntry for Framework to search and load
var PluginEntry impl.PagerDuty //nolint

// standalone mode for debugging
func main() {
	cmd := &cobra.Command{Use: "pagerduty"}
	timeAfter := cmd.Flags().StringP("timeAfter", "a", "", "collect data that are created after specified time, ie 2006-01-02T15:04:05Z")

	// TODO add your cmd flag if necessary
	// yourFlag := cmd.Flags().IntP("yourFlag", "y", 8, "TODO add description here")
	// _ = cmd.MarkFlagRequired("yourFlag")

	cmd.Run = func(cmd *cobra.Command, args []string) {
		runner.DirectRun(cmd, args, PluginEntry, map[string]interface{}{
			// TODO add more custom params here
		}, *timeAfter)
	}
	runner.RunCmd(cmd)
}
