/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.exec;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.ignite3.internal.lang.SqlExceptionMapperUtil;
import org.apache.ignite3.internal.sql.engine.QueryCancelledException;
import org.apache.ignite3.internal.sql.engine.exec.AsyncDataCursor;
import org.apache.ignite3.internal.sql.engine.tx.QueryTransactionWrapper;
import org.apache.ignite3.internal.util.AsyncCursor;
import org.apache.ignite3.internal.util.CompletableFutures;
import org.apache.ignite3.internal.util.ExceptionUtils;

class TxAwareAsyncCursor<T>
implements AsyncDataCursor<T> {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final CompletableFuture<Void> closeResult = new CompletableFuture();
    private final QueryTransactionWrapper txWrapper;
    private final AsyncCursor<T> dataCursor;
    private final CompletableFuture<Void> firstPageReady;
    private final Function<AsyncDataCursor.CancellationReason, CompletableFuture<Void>> closeHandler;
    private final Consumer<Throwable> errorListener;

    TxAwareAsyncCursor(QueryTransactionWrapper txWrapper, AsyncCursor<T> dataCursor, CompletableFuture<Void> firstPageReady, Function<AsyncDataCursor.CancellationReason, CompletableFuture<Void>> closeHandler, Consumer<Throwable> errorListener) {
        this.txWrapper = txWrapper;
        this.dataCursor = dataCursor;
        this.firstPageReady = firstPageReady;
        this.closeHandler = closeHandler;
        this.errorListener = errorListener;
    }

    @Override
    public CompletableFuture<AsyncCursor.BatchedResult<T>> requestNextAsync(int rows) {
        return ((CompletableFuture)this.dataCursor.requestNextAsync(rows).handle((batch, error) -> {
            if (error != null) {
                return this.handleError((Throwable)error).thenApply(none -> batch);
            }
            CompletableFuture<Object> fut = batch.hasMore() ? CompletableFutures.nullCompletedFuture() : this.closeAsync();
            return fut.thenApply(none -> batch);
        })).thenCompose(Function.identity());
    }

    @Override
    public CompletableFuture<Void> cancelAsync(AsyncDataCursor.CancellationReason reason) {
        if (!this.closed.compareAndSet(false, true)) {
            return this.closeResult;
        }
        ((CompletableFuture)this.closeHandler.apply(reason).thenCompose(ignored -> {
            if (reason != AsyncDataCursor.CancellationReason.CLOSE) {
                String message = reason == AsyncDataCursor.CancellationReason.TIMEOUT ? "Query timeout" : "The query was cancelled while executing.";
                QueryCancelledException cancelEx = new QueryCancelledException(message);
                this.errorListener.accept(cancelEx);
                return this.txWrapper.finalise(cancelEx);
            }
            return this.txWrapper.finalise();
        })).whenComplete((r, e) -> {
            if (e != null) {
                this.closeResult.completeExceptionally((Throwable)e);
            } else {
                this.closeResult.complete(null);
            }
        });
        return this.closeResult;
    }

    @Override
    public CompletableFuture<Void> closeAsync() {
        return this.cancelAsync(AsyncDataCursor.CancellationReason.CLOSE);
    }

    @Override
    public CompletableFuture<Void> onClose() {
        return this.closeResult;
    }

    @Override
    public CompletableFuture<Void> onFirstPageReady() {
        return ((CompletableFuture)this.firstPageReady.handle((none, executionError) -> {
            if (executionError != null) {
                return this.handleError((Throwable)executionError);
            }
            return CompletableFutures.nullCompletedFuture();
        })).thenCompose(Function.identity());
    }

    private CompletableFuture<Void> handleError(Throwable throwable) {
        Throwable wrapped = TxAwareAsyncCursor.wrapIfNecessary(throwable);
        this.errorListener.accept(throwable);
        return ((CompletableFuture)((CompletableFuture)this.txWrapper.finalise(throwable).handle((none, rollbackError) -> {
            if (rollbackError != null) {
                wrapped.addSuppressed((Throwable)rollbackError);
            }
            return this.closeAsync();
        })).thenCompose(Function.identity())).handle((none, closeError) -> {
            if (closeError != null) {
                wrapped.addSuppressed((Throwable)closeError);
            }
            throw new CompletionException(wrapped);
        });
    }

    private static Throwable wrapIfNecessary(Throwable t) {
        Throwable err = ExceptionUtils.unwrapCause(t);
        return SqlExceptionMapperUtil.mapToPublicSqlException(err);
    }
}

