/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.disaster.system.message;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessage;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessageBuilder;
import org.apache.ignite3.internal.disaster.system.message.ResetClusterMessageSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.tostring.IgniteToStringExclude;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ResetClusterMessageImpl
implements ResetClusterMessage,
Cloneable {
    public static final short GROUP_TYPE = 15;
    public static final short TYPE = 1;
    @IgniteToStringInclude
    private final UUID clusterId;
    @IgniteToStringInclude
    private final String clusterName;
    @IgniteToStringInclude
    private final String conductor;
    @IgniteToStringInclude
    private final Set<String> currentMetaStorageNodes;
    @IgniteToStringInclude
    private final List<UUID> formerClusterIds;
    @IgniteToStringExclude
    private final String initialClusterConfiguration;
    @IgniteToStringInclude
    private final Integer metastorageReplicationFactor;
    @IgniteToStringInclude
    private final Set<String> newCmgNodes;
    @IgniteToStringInclude
    private final Set<String> participatingNodes;

    private ResetClusterMessageImpl(UUID clusterId, String clusterName, String conductor, Set<String> currentMetaStorageNodes, List<UUID> formerClusterIds, String initialClusterConfiguration, Integer metastorageReplicationFactor, Set<String> newCmgNodes, Set<String> participatingNodes) {
        this.clusterId = clusterId;
        this.clusterName = clusterName;
        this.conductor = conductor;
        this.currentMetaStorageNodes = currentMetaStorageNodes;
        this.formerClusterIds = formerClusterIds;
        this.initialClusterConfiguration = initialClusterConfiguration;
        this.metastorageReplicationFactor = metastorageReplicationFactor;
        this.newCmgNodes = newCmgNodes;
        this.participatingNodes = participatingNodes;
    }

    @Override
    public UUID clusterId() {
        return this.clusterId;
    }

    @Override
    public String clusterName() {
        return this.clusterName;
    }

    @Override
    public String conductor() {
        return this.conductor;
    }

    @Override
    public Set<String> currentMetaStorageNodes() {
        return this.currentMetaStorageNodes;
    }

    @Override
    public List<UUID> formerClusterIds() {
        return this.formerClusterIds;
    }

    @Override
    public String initialClusterConfiguration() {
        return this.initialClusterConfiguration;
    }

    @Override
    public Integer metastorageReplicationFactor() {
        return this.metastorageReplicationFactor;
    }

    @Override
    public Set<String> newCmgNodes() {
        return this.newCmgNodes;
    }

    @Override
    public Set<String> participatingNodes() {
        return this.participatingNodes;
    }

    public MessageSerializer serializer() {
        return ResetClusterMessageSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 15;
    }

    public String toString() {
        return S.toString(ResetClusterMessageImpl.class, this);
    }

    @Override
    public short messageType() {
        return 1;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ResetClusterMessageImpl otherMessage = (ResetClusterMessageImpl)other;
        return Objects.equals(this.clusterId, otherMessage.clusterId) && Objects.equals(this.clusterName, otherMessage.clusterName) && Objects.equals(this.conductor, otherMessage.conductor) && Objects.equals(this.currentMetaStorageNodes, otherMessage.currentMetaStorageNodes) && Objects.equals(this.formerClusterIds, otherMessage.formerClusterIds) && Objects.equals(this.initialClusterConfiguration, otherMessage.initialClusterConfiguration) && Objects.equals(this.metastorageReplicationFactor, otherMessage.metastorageReplicationFactor) && Objects.equals(this.newCmgNodes, otherMessage.newCmgNodes) && Objects.equals(this.participatingNodes, otherMessage.participatingNodes);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.clusterId, this.clusterName, this.conductor, this.currentMetaStorageNodes, this.formerClusterIds, this.initialClusterConfiguration, this.metastorageReplicationFactor, this.newCmgNodes, this.participatingNodes);
        return result;
    }

    @Override
    public ResetClusterMessageImpl clone() {
        try {
            return (ResetClusterMessageImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ResetClusterMessageBuilder builder() {
        return new Builder();
    }

    private static class Builder
    implements ResetClusterMessageBuilder {
        private UUID clusterId;
        private String clusterName;
        private String conductor;
        private Set<String> currentMetaStorageNodes;
        private List<UUID> formerClusterIds;
        private String initialClusterConfiguration;
        private Integer metastorageReplicationFactor;
        private Set<String> newCmgNodes;
        private Set<String> participatingNodes;

        private Builder() {
        }

        @Override
        public ResetClusterMessageBuilder clusterId(UUID clusterId) {
            Objects.requireNonNull(clusterId, "clusterId is not marked @Nullable");
            this.clusterId = clusterId;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder clusterName(String clusterName) {
            Objects.requireNonNull(clusterName, "clusterName is not marked @Nullable");
            this.clusterName = clusterName;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder conductor(String conductor) {
            this.conductor = conductor;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder currentMetaStorageNodes(Set<String> currentMetaStorageNodes) {
            Objects.requireNonNull(currentMetaStorageNodes, "currentMetaStorageNodes is not marked @Nullable");
            this.currentMetaStorageNodes = currentMetaStorageNodes;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder formerClusterIds(List<UUID> formerClusterIds) {
            Objects.requireNonNull(formerClusterIds, "formerClusterIds is not marked @Nullable");
            this.formerClusterIds = formerClusterIds;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder initialClusterConfiguration(String initialClusterConfiguration) {
            this.initialClusterConfiguration = initialClusterConfiguration;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder metastorageReplicationFactor(Integer metastorageReplicationFactor) {
            this.metastorageReplicationFactor = metastorageReplicationFactor;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder newCmgNodes(Set<String> newCmgNodes) {
            Objects.requireNonNull(newCmgNodes, "newCmgNodes is not marked @Nullable");
            this.newCmgNodes = newCmgNodes;
            return this;
        }

        @Override
        public ResetClusterMessageBuilder participatingNodes(Set<String> participatingNodes) {
            this.participatingNodes = participatingNodes;
            return this;
        }

        @Override
        public UUID clusterId() {
            return this.clusterId;
        }

        @Override
        public String clusterName() {
            return this.clusterName;
        }

        @Override
        public String conductor() {
            return this.conductor;
        }

        @Override
        public Set<String> currentMetaStorageNodes() {
            return this.currentMetaStorageNodes;
        }

        @Override
        public List<UUID> formerClusterIds() {
            return this.formerClusterIds;
        }

        @Override
        public String initialClusterConfiguration() {
            return this.initialClusterConfiguration;
        }

        @Override
        public Integer metastorageReplicationFactor() {
            return this.metastorageReplicationFactor;
        }

        @Override
        public Set<String> newCmgNodes() {
            return this.newCmgNodes;
        }

        @Override
        public Set<String> participatingNodes() {
            return this.participatingNodes;
        }

        @Override
        public ResetClusterMessage build() {
            return new ResetClusterMessageImpl(Objects.requireNonNull(this.clusterId, "clusterId is not marked @Nullable"), Objects.requireNonNull(this.clusterName, "clusterName is not marked @Nullable"), this.conductor, Objects.requireNonNull(this.currentMetaStorageNodes, "currentMetaStorageNodes is not marked @Nullable"), Objects.requireNonNull(this.formerClusterIds, "formerClusterIds is not marked @Nullable"), this.initialClusterConfiguration, this.metastorageReplicationFactor, Objects.requireNonNull(this.newCmgNodes, "newCmgNodes is not marked @Nullable"), this.participatingNodes);
        }
    }
}

