/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import org.apache.ignite.raft.jraft.util.ArrayDeque;
import org.apache.ignite.raft.jraft.util.Recyclable;
import org.apache.ignite.raft.jraft.util.RecycleUtil;
import org.apache.ignite.raft.jraft.util.Recyclers;

public class SegmentList<T> {
    private static final int SEGMENT_SHIFT = 7;
    public static final int SEGMENT_SIZE = 128;
    private final ArrayDeque<Segment<T>> segments = new ArrayDeque();
    private int size = 0;
    private int firstOffset = 0;
    private final boolean recycleSegment;

    public SegmentList(boolean recycleSegment) {
        this.recycleSegment = recycleSegment;
    }

    public T get(int index) {
        return ((Segment)this.segments.get((index += this.firstOffset) >> 7)).get(index & 0x7F);
    }

    public T peekLast() {
        Segment<T> lastSeg = this.getLast();
        return lastSeg == null ? null : (T)lastSeg.peekLast();
    }

    public T peekFirst() {
        Segment<T> firstSeg = this.getFirst();
        return firstSeg == null ? null : (T)firstSeg.peekFirst();
    }

    private Segment<T> getFirst() {
        if (!this.segments.isEmpty()) {
            return this.segments.peekFirst();
        }
        return null;
    }

    public void add(T e) {
        Segment<Object> lastSeg = this.getLast();
        if (lastSeg == null || lastSeg.isReachEnd()) {
            lastSeg = Segment.newInstance(this.recycleSegment);
            this.segments.add(lastSeg);
        }
        lastSeg.add(e);
        ++this.size;
    }

    private Segment<T> getLast() {
        if (!this.segments.isEmpty()) {
            return this.segments.peekLast();
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public int segmentSize() {
        return this.segments.size();
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void removeFromFirstWhen(Predicate<T> predicate) {
        Segment<T> firstSeg = this.getFirst();
        while (true) {
            if (firstSeg == null) {
                this.size = 0;
                this.firstOffset = 0;
                return;
            }
            int removed = firstSeg.removeFromFirstWhen(predicate);
            if (removed == 0) break;
            this.size -= removed;
            this.firstOffset = firstSeg.offset;
            if (!firstSeg.isEmpty()) continue;
            RecycleUtil.recycle(this.segments.pollFirst());
            firstSeg = this.getFirst();
            this.firstOffset = 0;
        }
    }

    public void clear() {
        while (!this.segments.isEmpty()) {
            RecycleUtil.recycle(this.segments.pollLast());
        }
        this.firstOffset = 0;
        this.size = 0;
    }

    public void removeFromLastWhen(Predicate<T> predicate) {
        Segment<T> lastSeg = this.getLast();
        while (true) {
            if (lastSeg == null) {
                this.size = 0;
                this.firstOffset = 0;
                return;
            }
            int removed = lastSeg.removeFromLastWhen(predicate);
            if (removed == 0) break;
            this.size -= removed;
            if (!lastSeg.isEmpty()) continue;
            RecycleUtil.recycle(this.segments.pollLast());
            lastSeg = this.getLast();
        }
    }

    public void removeFromFirst(int toIndex) {
        Segment<T> firstSeg;
        int alignedIndex = toIndex + this.firstOffset;
        int toSegmentIndex = alignedIndex >> 7;
        int toIndexInSeg = alignedIndex & 0x7F;
        if (toSegmentIndex > 0) {
            this.segments.removeRange(0, toSegmentIndex);
            this.size -= (toSegmentIndex << 7) - this.firstOffset;
        }
        if ((firstSeg = this.getFirst()) != null) {
            this.size -= firstSeg.removeFromFirst(toIndexInSeg);
            this.firstOffset = firstSeg.offset;
            if (firstSeg.isEmpty()) {
                RecycleUtil.recycle(this.segments.pollFirst());
                this.firstOffset = 0;
            }
        } else {
            this.size = 0;
            this.firstOffset = 0;
        }
    }

    public void addAll(Collection<T> coll) {
        Object[] src = this.coll2Array(coll);
        int srcPos = 0;
        int srcSize = coll.size();
        Segment<Object> lastSeg = this.getLast();
        while (srcPos < srcSize) {
            if (lastSeg == null || lastSeg.isReachEnd()) {
                lastSeg = Segment.newInstance(this.recycleSegment);
                this.segments.add(lastSeg);
            }
            int len = Math.min(lastSeg.cap(), srcSize - srcPos);
            lastSeg.addAll(src, srcPos, len);
            srcPos += len;
            this.size += len;
        }
    }

    private Object[] coll2Array(Collection<T> coll) {
        Object[] src = coll.toArray();
        return src;
    }

    public String toString() {
        return "SegmentList [segments=" + String.valueOf(this.segments) + ", size=" + this.size + ", firstOffset=" + this.firstOffset + "]";
    }

    private static final class Segment<T>
    implements Recyclable {
        private static final Recyclers<Segment<?>> recyclers = new Recyclers<Segment<?>>(127){

            @Override
            protected Segment<?> newObject(Recyclers.Handle handle) {
                return new Segment(handle);
            }
        };
        private transient Recyclers.Handle handle;
        final T[] elements = new Object[128];
        int pos = 0;
        int offset = 0;

        public static Segment<?> newInstance(boolean recycleSegment) {
            if (recycleSegment) {
                return recyclers.get();
            }
            return new Segment();
        }

        Segment() {
            this(Recyclers.NOOP_HANDLE);
        }

        Segment(Recyclers.Handle handle) {
            this.handle = handle;
        }

        void clear() {
            this.offset = 0;
            this.pos = 0;
            Arrays.fill(this.elements, null);
        }

        @Override
        public boolean recycle() {
            this.clear();
            return recyclers.recycle(this, this.handle);
        }

        int cap() {
            return 128 - this.pos;
        }

        private void addAll(Object[] src, int srcPos, int len) {
            System.arraycopy(src, srcPos, this.elements, this.pos, len);
            this.pos += len;
        }

        boolean isReachEnd() {
            return this.pos == 128;
        }

        boolean isEmpty() {
            return this.size() == 0;
        }

        void add(T e) {
            this.elements[this.pos++] = e;
        }

        T get(int index) {
            if (index >= this.pos || index < this.offset) {
                throw new IndexOutOfBoundsException("Index=" + index + ", Offset=" + this.offset + ", Pos=" + this.pos);
            }
            return this.elements[index];
        }

        T peekLast() {
            return this.elements[this.pos - 1];
        }

        int size() {
            return this.pos - this.offset;
        }

        T peekFirst() {
            return this.elements[this.offset];
        }

        int removeFromLastWhen(Predicate<T> predicate) {
            T e;
            int removed = 0;
            for (int i = this.pos - 1; i >= this.offset && predicate.test(e = this.elements[i]); --i) {
                this.elements[i] = null;
                ++removed;
            }
            this.pos -= removed;
            return removed;
        }

        int removeFromFirstWhen(Predicate<T> predicate) {
            T e;
            int removed = 0;
            for (int i = this.offset; i < this.pos && predicate.test(e = this.elements[i]); ++i) {
                this.elements[i] = null;
                ++removed;
            }
            this.offset += removed;
            return removed;
        }

        int removeFromFirst(int toIndex) {
            int removed = 0;
            for (int i = this.offset; i < Math.min(toIndex, this.pos); ++i) {
                this.elements[i] = null;
                ++removed;
            }
            this.offset += removed;
            return removed;
        }

        public String toString() {
            StringBuilder b = new StringBuilder();
            for (int i = this.offset; i < this.pos; ++i) {
                b.append(this.elements[i]);
                if (i == this.pos - 1) continue;
                b.append(", ");
            }
            return "Segment [elements=" + b.toString() + ", offset=" + this.offset + ", pos=" + this.pos + "]";
        }
    }
}

