/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http2.impl.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.nio.AsyncPushConsumer;
import org.apache.hc.core5.http.nio.HandlerFactory;
import org.apache.hc.core5.http2.H2Error;
import org.apache.hc.core5.http2.H2StreamResetException;
import org.apache.hc.core5.http2.impl.nio.H2StreamChannel;
import org.apache.hc.core5.http2.impl.nio.H2StreamHandler;

class H2Stream {
    private static final long LINGER_TIME = 1000L;
    private final H2StreamChannel channel;
    private final H2StreamHandler handler;
    private final Consumer<State> stateChangeCallback;
    private final AtomicReference<State> transitionRef;
    private final AtomicBoolean released;
    private final AtomicBoolean cancelled;
    private volatile boolean reserved;
    private volatile boolean remoteClosed;

    H2Stream(H2StreamChannel channel, H2StreamHandler handler, Consumer<State> stateChangeCallback) {
        this.channel = channel;
        this.handler = handler;
        this.stateChangeCallback = stateChangeCallback;
        this.reserved = true;
        this.transitionRef = new AtomicReference<State>(State.RESERVED);
        this.released = new AtomicBoolean();
        this.cancelled = new AtomicBoolean();
    }

    int getId() {
        return this.channel.getId();
    }

    boolean isReserved() {
        return this.reserved;
    }

    private void triggerOpen() {
        if (this.transitionRef.compareAndSet(State.RESERVED, State.OPEN) && this.stateChangeCallback != null) {
            this.stateChangeCallback.accept(State.OPEN);
        }
    }

    private void triggerClosed() {
        if (this.transitionRef.compareAndSet(State.OPEN, State.CLOSED) && this.stateChangeCallback != null) {
            this.stateChangeCallback.accept(State.CLOSED);
        }
    }

    void activate() {
        this.reserved = false;
        this.triggerOpen();
    }

    AtomicInteger getOutputWindow() {
        return this.channel.getOutputWindow();
    }

    AtomicInteger getInputWindow() {
        return this.channel.getInputWindow();
    }

    private boolean isPastLingerDeadline() {
        long localResetTime = this.channel.getLocalResetTime();
        return localResetTime > 0L && localResetTime + 1000L < System.currentTimeMillis();
    }

    boolean isClosedPastLingerDeadline() {
        return this.channel.isLocalClosed() && (this.remoteClosed || this.isPastLingerDeadline());
    }

    boolean isClosed() {
        return this.channel.isLocalClosed() && (this.remoteClosed || this.channel.isLocalReset());
    }

    boolean isActive() {
        return !this.reserved && !this.isClosed();
    }

    boolean isRemoteClosed() {
        return this.remoteClosed;
    }

    void markRemoteClosed() {
        this.remoteClosed = true;
    }

    boolean isLocalClosed() {
        return this.channel.isLocalClosed();
    }

    void consumePromise(List<Header> headers) throws HttpException, IOException {
        try {
            if (this.channel.isLocalReset()) {
                return;
            }
            if (this.cancelled.get()) {
                this.localResetCancelled();
                return;
            }
            this.handler.consumePromise(headers);
            this.channel.markLocalClosed();
        }
        catch (ProtocolException ex) {
            this.localReset((Exception)((Object)ex), H2Error.PROTOCOL_ERROR);
        }
    }

    void consumeHeader(List<Header> headers, boolean endOfStream) throws HttpException, IOException {
        try {
            if (endOfStream) {
                this.remoteClosed = true;
            }
            if (this.channel.isLocalReset()) {
                return;
            }
            if (this.cancelled.get()) {
                this.localResetCancelled();
                return;
            }
            this.handler.consumeHeader(headers, this.remoteClosed);
        }
        catch (ProtocolException ex) {
            this.localReset((Exception)((Object)ex), H2Error.PROTOCOL_ERROR);
        }
    }

    void consumeData(ByteBuffer src, boolean endOfStream) throws HttpException, IOException {
        try {
            if (endOfStream) {
                this.remoteClosed = true;
            }
            if (this.channel.isLocalReset()) {
                return;
            }
            if (this.cancelled.get()) {
                this.localResetCancelled();
                return;
            }
            this.handler.consumeData(src, this.remoteClosed);
        }
        catch (CharacterCodingException ex) {
            this.localReset((Exception)ex, H2Error.INTERNAL_ERROR);
        }
        catch (ProtocolException ex) {
            this.localReset((Exception)((Object)ex), H2Error.PROTOCOL_ERROR);
        }
    }

    boolean isOutputReady() {
        return !this.reserved && !this.channel.isLocalClosed() && this.handler.isOutputReady();
    }

    void produceOutput() throws HttpException, IOException {
        try {
            this.handler.produceOutput();
        }
        catch (ProtocolException ex) {
            this.localReset((Exception)((Object)ex), H2Error.PROTOCOL_ERROR);
        }
    }

    void produceInputCapacityUpdate() throws IOException {
        this.handler.updateInputCapacity();
    }

    void fail(Exception cause) {
        this.remoteClosed = true;
        this.channel.markLocalClosed();
        if (this.released.compareAndSet(false, true)) {
            try {
                this.handler.failed(cause);
                this.handler.releaseResources();
            }
            finally {
                this.triggerClosed();
            }
        }
    }

    void localReset(Exception cause, int code) throws IOException {
        this.channel.localReset(code);
        if (this.released.compareAndSet(false, true)) {
            try {
                this.handler.failed(cause);
                this.handler.releaseResources();
            }
            finally {
                this.triggerClosed();
            }
        }
    }

    void localReset(Exception cause, H2Error error) throws IOException {
        this.localReset(cause, error != null ? error.getCode() : H2Error.INTERNAL_ERROR.getCode());
    }

    void localReset(H2StreamResetException ex) throws IOException {
        this.localReset((Exception)((Object)ex), ex.getCode());
    }

    void localResetCancelled() throws IOException {
        this.localReset(new H2StreamResetException(H2Error.CANCEL, "Cancelled"));
    }

    void handle(HttpException ex) throws IOException, HttpException {
        this.handler.handle(ex, this.remoteClosed);
    }

    HandlerFactory<AsyncPushConsumer> getPushHandlerFactory() {
        return this.handler.getPushHandlerFactory();
    }

    boolean abort() {
        if (this.cancelled.compareAndSet(false, true)) {
            this.channel.requestOutput();
            return true;
        }
        return false;
    }

    boolean abortGracefully() throws IOException {
        if (!this.isLocalClosed() && this.isRemoteClosed()) {
            this.channel.endStream();
            this.releaseResources();
            return true;
        }
        return this.abort();
    }

    void releaseResources() {
        if (this.released.compareAndSet(false, true)) {
            try {
                this.handler.releaseResources();
            }
            finally {
                this.triggerClosed();
            }
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[").append("id=").append(this.channel.getId()).append(", reserved=").append(this.reserved).append(", removeClosed=").append(this.remoteClosed).append(", localClosed=").append(this.channel.isLocalClosed()).append(", localReset=").append(this.channel.isLocalReset()).append("]");
        return buf.toString();
    }

    static enum State {
        RESERVED,
        OPEN,
        CLOSED;

    }
}

