/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn.jdbc.functions;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.txn.jdbc.MultiDataSourceJdbcResource;
import org.apache.hadoop.hive.metastore.txn.jdbc.TransactionalFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

public class CleanupRecordsFunction
implements TransactionalFunction<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(CleanupRecordsFunction.class);
    private static final EnumSet<HiveObjectType> HIVE_OBJECT_TYPES = EnumSet.of(HiveObjectType.DATABASE, HiveObjectType.TABLE, HiveObjectType.PARTITION);
    private static final Map<BiFunction<HiveObjectType, Boolean, Boolean>, String> DELETE_COMMANDS = new LinkedHashMap<BiFunction<HiveObjectType, Boolean, Boolean>, String>(){
        {
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HIVE_OBJECT_TYPES.contains(hiveObjectType), "DELETE FROM \"TXN_COMPONENTS\" WHERE \"TC_DATABASE\" = :dbName AND (\"TC_TABLE\" = :tableName OR :tableName IS NULL) AND (\"TC_PARTITION\" = :partName OR :partName IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HIVE_OBJECT_TYPES.contains(hiveObjectType), "DELETE FROM \"COMPLETED_TXN_COMPONENTS\" WHERE (\"CTC_DATABASE\" = :dbName) AND (\"CTC_TABLE\" = :tableName OR :tableName IS NULL) AND (\"CTC_PARTITION\" = :partName OR :partName IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HIVE_OBJECT_TYPES.contains(hiveObjectType), "DELETE FROM \"COMPACTION_QUEUE\" WHERE \"CQ_DATABASE\" = :dbName AND (\"CQ_TABLE\" = :tableName OR :tableName IS NULL) AND (\"CQ_PARTITION\" = :partName OR :partName IS NULL) AND (\"CQ_TXN_ID\" != :txnId OR :txnId IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HIVE_OBJECT_TYPES.contains(hiveObjectType), "DELETE FROM \"COMPLETED_COMPACTIONS\" WHERE \"CC_DATABASE\" = :dbName AND (\"CC_TABLE\" = :tableName OR :tableName IS NULL) AND (\"CC_PARTITION\" = :partName OR :partName IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HiveObjectType.DATABASE.equals(hiveObjectType) || HiveObjectType.TABLE.equals(hiveObjectType) && keepTxnToWriteIdMetaData == false, "DELETE FROM \"TXN_TO_WRITE_ID\" WHERE \"T2W_DATABASE\" = :dbName AND (\"T2W_TABLE\" = :tableName OR :tableName IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HiveObjectType.DATABASE.equals(hiveObjectType) || HiveObjectType.TABLE.equals(hiveObjectType) && keepTxnToWriteIdMetaData == false, "DELETE FROM \"NEXT_WRITE_ID\" WHERE \"NWI_DATABASE\" = :dbName AND (\"NWI_TABLE\" = :tableName OR :tableName IS NULL)");
            this.put((hiveObjectType, keepTxnToWriteIdMetaData) -> HIVE_OBJECT_TYPES.contains(hiveObjectType), "DELETE FROM \"COMPACTION_METRICS_CACHE\" WHERE \"CMC_DATABASE\" = :dbName AND (\"CMC_TABLE\" = :tableName OR :tableName IS NULL) AND (\"CMC_PARTITION\" = :partName OR :partName IS NULL)");
        }
    };
    private final HiveObjectType type;
    private final Database db;
    private final Table table;
    private final Iterator<Partition> partitionIterator;
    private final String defaultCatalog;
    private final boolean keepTxnToWriteIdMetaData;
    private final Long txnId;

    public CleanupRecordsFunction(HiveObjectType type, Database db, Table table, Iterator<Partition> partitionIterator, String defaultCatalog, boolean keepTxnToWriteIdMetaData, Long txnId) {
        this.type = type;
        this.db = db;
        this.table = table;
        this.partitionIterator = partitionIterator;
        this.defaultCatalog = defaultCatalog;
        this.keepTxnToWriteIdMetaData = keepTxnToWriteIdMetaData;
        this.txnId = txnId;
    }

    @Override
    public Void execute(MultiDataSourceJdbcResource jdbcResource) throws MetaException {
        ArrayList<MapSqlParameterSource> paramSources = new ArrayList<MapSqlParameterSource>();
        switch (this.type) {
            case DATABASE: {
                if (!this.defaultCatalog.equals(this.db.getCatalogName())) {
                    LOG.debug("Skipping cleanup because db: " + this.db.getName() + " belongs to catalog other than default catalog: " + this.db.getCatalogName());
                    return null;
                }
                paramSources.add(new MapSqlParameterSource().addValue("dbName", (Object)this.db.getName().toLowerCase()).addValue("tableName", null, 12).addValue("partName", null, 12).addValue("txnId", (Object)this.txnId, -5));
                break;
            }
            case TABLE: {
                if (!this.defaultCatalog.equals(this.table.getCatName())) {
                    LOG.debug("Skipping cleanup because table: {} belongs to catalog other than default catalog: {}", (Object)this.table.getTableName(), (Object)this.table.getCatName());
                    return null;
                }
                paramSources.add(new MapSqlParameterSource().addValue("dbName", (Object)this.table.getDbName().toLowerCase()).addValue("tableName", (Object)this.table.getTableName().toLowerCase(), 12).addValue("partName", null, 12).addValue("txnId", null, -5));
                break;
            }
            case PARTITION: {
                if (!this.defaultCatalog.equals(this.table.getCatName())) {
                    LOG.debug("Skipping cleanup because partitions belong to catalog other than default catalog: {}", (Object)this.table.getCatName());
                    return null;
                }
                List partCols = this.table.getPartitionKeys();
                while (this.partitionIterator.hasNext()) {
                    Partition partition = this.partitionIterator.next();
                    List partVals = partition.getValues();
                    paramSources.add(new MapSqlParameterSource().addValue("dbName", (Object)this.table.getDbName().toLowerCase()).addValue("tableName", (Object)this.table.getTableName().toLowerCase(), 12).addValue("partName", (Object)Warehouse.makePartName((List)partCols, (List)partVals), 12).addValue("txnId", null, -5));
                }
                break;
            }
        }
        try {
            for (MapSqlParameterSource parameterSource : paramSources) {
                for (Map.Entry entry : DELETE_COMMANDS.entrySet()) {
                    if (!((Boolean)((BiFunction)entry.getKey()).apply(this.type, this.keepTxnToWriteIdMetaData)).booleanValue()) continue;
                    jdbcResource.getJdbcTemplate().update((String)entry.getValue(), (SqlParameterSource)parameterSource);
                }
            }
        }
        catch (DataAccessException e) {
            Throwable ex = e;
            do {
                String message;
                if (!StringUtils.isNotBlank((CharSequence)(message = ex.getMessage())) || !message.contains("does not exist")) continue;
                LOG.warn("Cannot perform cleanup since metastore table does not exist");
                return null;
            } while ((ex = ex.getCause()) != null);
            throw e;
        }
        return null;
    }
}

