/*
 * Decompiled with CFR 0.152.
 */
package org.apache.atlas.model.instance;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.atlas.model.instance.AtlasClassification;
import org.apache.atlas.model.typedef.AtlasBaseTypeDef;
import org.apache.commons.collections.CollectionUtils;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, setterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY, fieldVisibility=JsonAutoDetect.Visibility.NONE)
@JsonSerialize(include=JsonSerialize.Inclusion.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.PROPERTY)
public class ClassificationAssociateRequest {
    private AtlasClassification classification;
    private List<String> entityGuids;
    private List<Map<String, Object>> entitiesUniqueAttributes;
    private String entityTypeName;

    public ClassificationAssociateRequest() {
        this(null, null);
    }

    public ClassificationAssociateRequest(List<String> entityGuids, AtlasClassification classification) {
        this.setEntityGuids(entityGuids);
        this.setClassification(classification);
    }

    public ClassificationAssociateRequest(String entityTypeName, List<Map<String, Object>> entitiesUniqueAttributes, AtlasClassification classification) {
        this.setEntitiesUniqueAttributes(entitiesUniqueAttributes);
        this.setClassification(classification);
        this.setEntityTypeName(entityTypeName);
    }

    public ClassificationAssociateRequest(List<String> entityGuids, String entityTypeName, List<Map<String, Object>> entitiesUniqueAttributes, AtlasClassification classification) {
        this.setEntityGuids(entityGuids);
        this.setEntitiesUniqueAttributes(entitiesUniqueAttributes);
        this.setClassification(classification);
        this.setEntityTypeName(entityTypeName);
    }

    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    public void setEntityTypeName(String entityTypeName) {
        this.entityTypeName = entityTypeName;
    }

    public List<Map<String, Object>> getEntitiesUniqueAttributes() {
        return this.entitiesUniqueAttributes;
    }

    public void setEntitiesUniqueAttributes(List<Map<String, Object>> entitiesUniqueAttributes) {
        this.entitiesUniqueAttributes = entitiesUniqueAttributes;
    }

    public AtlasClassification getClassification() {
        return this.classification;
    }

    public void setClassification(AtlasClassification classification) {
        this.classification = classification;
    }

    public List<String> getEntityGuids() {
        return this.entityGuids;
    }

    public void setEntityGuids(List<String> entityGuids) {
        this.entityGuids = entityGuids;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassificationAssociateRequest that = (ClassificationAssociateRequest)o;
        return Objects.equals(this.classification, that.classification) && Objects.equals(this.entityGuids, that.entityGuids) && CollectionUtils.isEqualCollection(this.entitiesUniqueAttributes, that.entitiesUniqueAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.classification, this.entityGuids, this.entitiesUniqueAttributes);
    }

    public StringBuilder toString(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("ClassificationAssociateRequest{");
        sb.append("classification='");
        if (this.classification != null) {
            this.classification.toString(sb);
        }
        sb.append("', entityGuids=[");
        AtlasBaseTypeDef.dumpObjects(this.entityGuids, sb);
        sb.append("]");
        sb.append(", entityTypeName=[");
        if (this.entityTypeName != null) {
            sb.append(this.entityTypeName);
        }
        sb.append("]");
        sb.append(", entitiesUniqueAttributes=[");
        AtlasBaseTypeDef.dumpObjects(this.entitiesUniqueAttributes, sb);
        sb.append("]");
        sb.append('}');
        return sb;
    }

    public String toString() {
        return this.toString(new StringBuilder()).toString();
    }
}

