/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.flush;

import org.datanucleus.flush.SCOOperation;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.state.DNStateManager;
import org.datanucleus.store.types.scostore.CollectionStore;
import org.datanucleus.store.types.scostore.Store;
import org.datanucleus.util.StringUtils;

public class CollectionRemoveOperation<E>
implements SCOOperation {
    final DNStateManager sm;
    final int fieldNumber;
    final CollectionStore<E> store;
    final E value;
    final boolean allowCascadeDelete;

    public CollectionRemoveOperation(DNStateManager sm, CollectionStore<E> store, E value, boolean allowCascadeDelete) {
        this.sm = sm;
        this.fieldNumber = store.getOwnerMemberMetaData().getAbsoluteFieldNumber();
        this.store = store;
        this.value = value;
        this.allowCascadeDelete = allowCascadeDelete;
    }

    public CollectionRemoveOperation(DNStateManager sm, int fieldNum, E value, boolean allowCascadeDelete) {
        this.sm = sm;
        this.fieldNumber = fieldNum;
        this.store = null;
        this.value = value;
        this.allowCascadeDelete = allowCascadeDelete;
    }

    @Override
    public AbstractMemberMetaData getMemberMetaData() {
        return this.store != null ? this.store.getOwnerMemberMetaData() : this.sm.getClassMetaData().getMetaDataForManagedMemberAtAbsolutePosition(this.fieldNumber);
    }

    public E getValue() {
        return this.value;
    }

    @Override
    public void perform() {
        if (this.store != null) {
            this.store.remove(this.sm, this.value, -1, this.allowCascadeDelete);
        }
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public DNStateManager getStateManager() {
        return this.sm;
    }

    public String toString() {
        return "COLLECTION REMOVE : " + this.sm + " field=" + this.getMemberMetaData().getName() + " value=" + StringUtils.toJVMIDString(this.value);
    }
}

