/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Apache Argus (incubating)"})
@InterfaceStability.Evolving
public final class HiveAuthzContext {
    private final String userIpAddress;
    private final String commandString;
    private final List<String> forwardedAddresses;
    private final Map<String, Object> clientConfig;

    private HiveAuthzContext(Builder builder) {
        this.userIpAddress = builder.userIpAddress;
        this.commandString = builder.commandString;
        this.forwardedAddresses = builder.forwardedAddresses;
        this.clientConfig = builder.clientConfig;
    }

    public String getIpAddress() {
        return this.userIpAddress;
    }

    public String getCommandString() {
        return this.commandString;
    }

    public List<String> getForwardedAddresses() {
        return this.forwardedAddresses;
    }

    public Map<String, Object> getClientConfig() {
        return this.clientConfig;
    }

    public String toString() {
        return "QueryContext [commandString=" + this.commandString + ", forwardedAddresses=" + String.valueOf(this.forwardedAddresses) + ", clientConfig=" + String.valueOf(this.clientConfig) + "]";
    }

    public static class Builder {
        private String commandString;
        private List<String> forwardedAddresses;
        private String userIpAddress;
        private Map<String, Object> clientConfig;

        public String getUserIpAddress() {
            return this.userIpAddress;
        }

        public void setUserIpAddress(String userIpAddress) {
            this.userIpAddress = userIpAddress;
        }

        public String getCommandString() {
            return this.commandString;
        }

        public void setCommandString(String commandString) {
            this.commandString = commandString;
        }

        public List<String> getForwardedAddresses() {
            return this.forwardedAddresses;
        }

        public void setForwardedAddresses(List<String> forwardedAddresses) {
            this.forwardedAddresses = forwardedAddresses;
        }

        public Map<String, Object> getClientConfig() {
            return this.clientConfig;
        }

        public void setClientConfig(Map<String, Object> clientConfig) {
            this.clientConfig = clientConfig;
        }

        public HiveAuthzContext build() {
            return new HiveAuthzContext(this);
        }
    }
}

